/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.BankAccount;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"bankAccount", "transferInstrumentId"})
public class Counterparty {
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private BankAccount bankAccount;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    private String transferInstrumentId;

    public Counterparty bankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Counterparty transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Counterparty counterparty = (Counterparty)o;
        return Objects.equals(this.bankAccount, counterparty.bankAccount) && Objects.equals(this.transferInstrumentId, counterparty.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccount, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Counterparty {\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Counterparty fromJson(String jsonString) throws JsonProcessingException {
        return (Counterparty)JSON.getMapper().readValue(jsonString, Counterparty.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

