/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"country", "identification", "identificationType"})
public class BankIdentification {
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_IDENTIFICATION = "identification";
    private String identification;
    public static final String JSON_PROPERTY_IDENTIFICATION_TYPE = "identificationType";
    private IdentificationTypeEnum identificationType;

    public BankIdentification country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public BankIdentification identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="identification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentification() {
        return this.identification;
    }

    @JsonProperty(value="identification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public BankIdentification identificationType(IdentificationTypeEnum identificationType) {
        this.identificationType = identificationType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="identificationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentificationTypeEnum getIdentificationType() {
        return this.identificationType;
    }

    @JsonProperty(value="identificationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentificationType(IdentificationTypeEnum identificationType) {
        this.identificationType = identificationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankIdentification bankIdentification = (BankIdentification)o;
        return Objects.equals(this.country, bankIdentification.country) && Objects.equals(this.identification, bankIdentification.identification) && Objects.equals((Object)this.identificationType, (Object)bankIdentification.identificationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.country, this.identification, this.identificationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankIdentification {\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    identificationType: ").append(this.toIndentedString((Object)this.identificationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BankIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (BankIdentification)JSON.getMapper().readValue(jsonString, BankIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IdentificationTypeEnum {
        IBAN("iban"),
        ROUTINGNUMBER("routingNumber");

        private String value;

        private IdentificationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IdentificationTypeEnum fromValue(String value) {
            for (IdentificationTypeEnum b : IdentificationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

