/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.legalentitymanagement.Document;
import com.adyen.model.legalentitymanagement.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DocumentsApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * Documents constructor in {@link com.adyen.service.legalentitymanagement package}.
    * @param client {@link Client } (required)
    */
    public DocumentsApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    /**
    * Documents constructor in {@link com.adyen.service.legalentitymanagement package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public DocumentsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Delete a document
    *
    * @param id {@link String } The unique identifier of the document to be deleted. (required)
    * @throws ApiException if fails to make API call
    */
    public void deleteDocument(String id) throws ApiException, IOException {
        deleteDocument(id, null);
    }

    /**
    * Delete a document
    *
    * @param id {@link String } The unique identifier of the document to be deleted. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @throws ApiException if fails to make API call
    */
    public void deleteDocument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/documents/{id}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    /**
    * Get a document
    *
    * @param id {@link String } The unique identifier of the document. (required)
    * @return {@link Document }
    * @throws ApiException if fails to make API call
    */
    public Document getDocument(String id) throws ApiException, IOException {
        return getDocument(id, null);
    }

    /**
    * Get a document
    *
    * @param id {@link String } The unique identifier of the document. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Document }
    * @throws ApiException if fails to make API call
    */
    public Document getDocument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/documents/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Document.fromJson(jsonResult);
    }

    /**
    * Update a document
    *
    * @param id {@link String } The unique identifier of the document to be updated. (required)
    * @param document {@link Document }  (required)
    * @return {@link Document }
    * @throws ApiException if fails to make API call
    */
    public Document updateDocument(String id, Document document) throws ApiException, IOException {
        return updateDocument(id, document, null);
    }

    /**
    * Update a document
    *
    * @param id {@link String } The unique identifier of the document to be updated. (required)
    * @param document {@link Document }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Document }
    * @throws ApiException if fails to make API call
    */
    public Document updateDocument(String id, Document document, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = document.toJson();
        Resource resource = new Resource(this, this.baseURL + "/documents/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Document.fromJson(jsonResult);
    }

    /**
    * Upload a document for verification checks
    *
    * @param document {@link Document }  (required)
    * @return {@link Document }
    * @throws ApiException if fails to make API call
    */
    public Document uploadDocumentForVerificationChecks(Document document) throws ApiException, IOException {
        return uploadDocumentForVerificationChecks(document, null);
    }

    /**
    * Upload a document for verification checks
    *
    * @param document {@link Document }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Document }
    * @throws ApiException if fails to make API call
    */
    public Document uploadDocumentForVerificationChecks(Document document, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = document.toJson();
        Resource resource = new Resource(this, this.baseURL + "/documents", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Document.fromJson(jsonResult);
    }
}
