/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ThreeDS2Result
 */
@JsonPropertyOrder({
  ThreeDS2Result.JSON_PROPERTY_AUTHENTICATION_VALUE,
  ThreeDS2Result.JSON_PROPERTY_CAVV_ALGORITHM,
  ThreeDS2Result.JSON_PROPERTY_CHALLENGE_CANCEL,
  ThreeDS2Result.JSON_PROPERTY_DS_TRANS_I_D,
  ThreeDS2Result.JSON_PROPERTY_ECI,
  ThreeDS2Result.JSON_PROPERTY_EXEMPTION_INDICATOR,
  ThreeDS2Result.JSON_PROPERTY_MESSAGE_VERSION,
  ThreeDS2Result.JSON_PROPERTY_RISK_SCORE,
  ThreeDS2Result.JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND,
  ThreeDS2Result.JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D,
  ThreeDS2Result.JSON_PROPERTY_TIMESTAMP,
  ThreeDS2Result.JSON_PROPERTY_TRANS_STATUS,
  ThreeDS2Result.JSON_PROPERTY_TRANS_STATUS_REASON,
  ThreeDS2Result.JSON_PROPERTY_WHITE_LIST_STATUS
})

public class ThreeDS2Result {
  public static final String JSON_PROPERTY_AUTHENTICATION_VALUE = "authenticationValue";
  private String authenticationValue;

  public static final String JSON_PROPERTY_CAVV_ALGORITHM = "cavvAlgorithm";
  private String cavvAlgorithm;

  /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).
   */
  public enum ChallengeCancelEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05"),
    
    _06("06"),
    
    _07("07");

    private String value;

    ChallengeCancelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChallengeCancelEnum fromValue(String value) {
      for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHALLENGE_CANCEL = "challengeCancel";
  private ChallengeCancelEnum challengeCancel;

  public static final String JSON_PROPERTY_DS_TRANS_I_D = "dsTransID";
  private String dsTransID;

  public static final String JSON_PROPERTY_ECI = "eci";
  private String eci;

  /**
   * Indicates the exemption type that was applied by the issuer to the authentication, if exemption applied. Allowed values: * &#x60;lowValue&#x60; * &#x60;secureCorporate&#x60; * &#x60;trustedBeneficiary&#x60; * &#x60;transactionRiskAnalysis&#x60; 
   */
  public enum ExemptionIndicatorEnum {
    LOWVALUE("lowValue"),
    
    SECURECORPORATE("secureCorporate"),
    
    TRUSTEDBENEFICIARY("trustedBeneficiary"),
    
    TRANSACTIONRISKANALYSIS("transactionRiskAnalysis");

    private String value;

    ExemptionIndicatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ExemptionIndicatorEnum fromValue(String value) {
      for (ExemptionIndicatorEnum b : ExemptionIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EXEMPTION_INDICATOR = "exemptionIndicator";
  private ExemptionIndicatorEnum exemptionIndicator;

  public static final String JSON_PROPERTY_MESSAGE_VERSION = "messageVersion";
  private String messageVersion;

  public static final String JSON_PROPERTY_RISK_SCORE = "riskScore";
  private String riskScore;

  /**
   * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
   */
  public enum ThreeDSRequestorChallengeIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05"),
    
    _06("06");

    private String value;

    ThreeDSRequestorChallengeIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ThreeDSRequestorChallengeIndEnum fromValue(String value) {
      for (ThreeDSRequestorChallengeIndEnum b : ThreeDSRequestorChallengeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND = "threeDSRequestorChallengeInd";
  private ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd;

  public static final String JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D = "threeDSServerTransID";
  private String threeDSServerTransID;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private String timestamp;

  public static final String JSON_PROPERTY_TRANS_STATUS = "transStatus";
  private String transStatus;

  public static final String JSON_PROPERTY_TRANS_STATUS_REASON = "transStatusReason";
  private String transStatusReason;

  public static final String JSON_PROPERTY_WHITE_LIST_STATUS = "whiteListStatus";
  private String whiteListStatus;

  public ThreeDS2Result() { 
  }

  public ThreeDS2Result authenticationValue(String authenticationValue) {
    this.authenticationValue = authenticationValue;
    return this;
  }

   /**
   * The &#x60;authenticationValue&#x60; value as defined in the 3D Secure 2 specification.
   * @return authenticationValue
  **/
  @ApiModelProperty(value = "The `authenticationValue` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAuthenticationValue() {
    return authenticationValue;
  }


 /**
  * The &#x60;authenticationValue&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param authenticationValue
  */ 
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationValue(String authenticationValue) {
    this.authenticationValue = authenticationValue;
  }


  public ThreeDS2Result cavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
    return this;
  }

   /**
   * The algorithm used by the ACS to calculate the authentication value, only for Cartes Bancaires integrations.
   * @return cavvAlgorithm
  **/
  @ApiModelProperty(value = "The algorithm used by the ACS to calculate the authentication value, only for Cartes Bancaires integrations.")
  @JsonProperty(JSON_PROPERTY_CAVV_ALGORITHM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCavvAlgorithm() {
    return cavvAlgorithm;
  }


 /**
  * The algorithm used by the ACS to calculate the authentication value, only for Cartes Bancaires integrations.
  *
  * @param cavvAlgorithm
  */ 
  @JsonProperty(JSON_PROPERTY_CAVV_ALGORITHM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
  }


  public ThreeDS2Result challengeCancel(ChallengeCancelEnum challengeCancel) {
    this.challengeCancel = challengeCancel;
    return this;
  }

   /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).
   * @return challengeCancel
  **/
  @ApiModelProperty(value = "Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).")
  @JsonProperty(JSON_PROPERTY_CHALLENGE_CANCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChallengeCancelEnum getChallengeCancel() {
    return challengeCancel;
  }


 /**
  * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).
  *
  * @param challengeCancel
  */ 
  @JsonProperty(JSON_PROPERTY_CHALLENGE_CANCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
    this.challengeCancel = challengeCancel;
  }


  public ThreeDS2Result dsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
    return this;
  }

   /**
   * The &#x60;dsTransID&#x60; value as defined in the 3D Secure 2 specification.
   * @return dsTransID
  **/
  @ApiModelProperty(value = "The `dsTransID` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_DS_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDsTransID() {
    return dsTransID;
  }


 /**
  * The &#x60;dsTransID&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param dsTransID
  */ 
  @JsonProperty(JSON_PROPERTY_DS_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
  }


  public ThreeDS2Result eci(String eci) {
    this.eci = eci;
    return this;
  }

   /**
   * The &#x60;eci&#x60; value as defined in the 3D Secure 2 specification.
   * @return eci
  **/
  @ApiModelProperty(value = "The `eci` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_ECI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEci() {
    return eci;
  }


 /**
  * The &#x60;eci&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param eci
  */ 
  @JsonProperty(JSON_PROPERTY_ECI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEci(String eci) {
    this.eci = eci;
  }


  public ThreeDS2Result exemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
    this.exemptionIndicator = exemptionIndicator;
    return this;
  }

   /**
   * Indicates the exemption type that was applied by the issuer to the authentication, if exemption applied. Allowed values: * &#x60;lowValue&#x60; * &#x60;secureCorporate&#x60; * &#x60;trustedBeneficiary&#x60; * &#x60;transactionRiskAnalysis&#x60; 
   * @return exemptionIndicator
  **/
  @ApiModelProperty(value = "Indicates the exemption type that was applied by the issuer to the authentication, if exemption applied. Allowed values: * `lowValue` * `secureCorporate` * `trustedBeneficiary` * `transactionRiskAnalysis` ")
  @JsonProperty(JSON_PROPERTY_EXEMPTION_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExemptionIndicatorEnum getExemptionIndicator() {
    return exemptionIndicator;
  }


 /**
  * Indicates the exemption type that was applied by the issuer to the authentication, if exemption applied. Allowed values: * &#x60;lowValue&#x60; * &#x60;secureCorporate&#x60; * &#x60;trustedBeneficiary&#x60; * &#x60;transactionRiskAnalysis&#x60; 
  *
  * @param exemptionIndicator
  */ 
  @JsonProperty(JSON_PROPERTY_EXEMPTION_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
    this.exemptionIndicator = exemptionIndicator;
  }


  public ThreeDS2Result messageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
    return this;
  }

   /**
   * The &#x60;messageVersion&#x60; value as defined in the 3D Secure 2 specification.
   * @return messageVersion
  **/
  @ApiModelProperty(value = "The `messageVersion` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageVersion() {
    return messageVersion;
  }


 /**
  * The &#x60;messageVersion&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param messageVersion
  */ 
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
  }


  public ThreeDS2Result riskScore(String riskScore) {
    this.riskScore = riskScore;
    return this;
  }

   /**
   * Risk score calculated by Cartes Bancaires Directory Server (DS).
   * @return riskScore
  **/
  @ApiModelProperty(value = "Risk score calculated by Cartes Bancaires Directory Server (DS).")
  @JsonProperty(JSON_PROPERTY_RISK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRiskScore() {
    return riskScore;
  }


 /**
  * Risk score calculated by Cartes Bancaires Directory Server (DS).
  *
  * @param riskScore
  */ 
  @JsonProperty(JSON_PROPERTY_RISK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskScore(String riskScore) {
    this.riskScore = riskScore;
  }


  public ThreeDS2Result threeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
    this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
    return this;
  }

   /**
   * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
   * @return threeDSRequestorChallengeInd
  **/
  @ApiModelProperty(value = "Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDSRequestorChallengeIndEnum getThreeDSRequestorChallengeInd() {
    return threeDSRequestorChallengeInd;
  }


 /**
  * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
  *
  * @param threeDSRequestorChallengeInd
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
    this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
  }


  public ThreeDS2Result threeDSServerTransID(String threeDSServerTransID) {
    this.threeDSServerTransID = threeDSServerTransID;
    return this;
  }

   /**
   * The &#x60;threeDSServerTransID&#x60; value as defined in the 3D Secure 2 specification.
   * @return threeDSServerTransID
  **/
  @ApiModelProperty(value = "The `threeDSServerTransID` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThreeDSServerTransID() {
    return threeDSServerTransID;
  }


 /**
  * The &#x60;threeDSServerTransID&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param threeDSServerTransID
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSServerTransID(String threeDSServerTransID) {
    this.threeDSServerTransID = threeDSServerTransID;
  }


  public ThreeDS2Result timestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * The &#x60;timestamp&#x60; value of the 3D Secure 2 authentication.
   * @return timestamp
  **/
  @ApiModelProperty(value = "The `timestamp` value of the 3D Secure 2 authentication.")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimestamp() {
    return timestamp;
  }


 /**
  * The &#x60;timestamp&#x60; value of the 3D Secure 2 authentication.
  *
  * @param timestamp
  */ 
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimestamp(String timestamp) {
    this.timestamp = timestamp;
  }


  public ThreeDS2Result transStatus(String transStatus) {
    this.transStatus = transStatus;
    return this;
  }

   /**
   * The &#x60;transStatus&#x60; value as defined in the 3D Secure 2 specification.
   * @return transStatus
  **/
  @ApiModelProperty(value = "The `transStatus` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransStatus() {
    return transStatus;
  }


 /**
  * The &#x60;transStatus&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param transStatus
  */ 
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransStatus(String transStatus) {
    this.transStatus = transStatus;
  }


  public ThreeDS2Result transStatusReason(String transStatusReason) {
    this.transStatusReason = transStatusReason;
    return this;
  }

   /**
   * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
   * @return transStatusReason
  **/
  @ApiModelProperty(value = "Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransStatusReason() {
    return transStatusReason;
  }


 /**
  * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
  *
  * @param transStatusReason
  */ 
  @JsonProperty(JSON_PROPERTY_TRANS_STATUS_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransStatusReason(String transStatusReason) {
    this.transStatusReason = transStatusReason;
  }


  public ThreeDS2Result whiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
    return this;
  }

   /**
   * The &#x60;whiteListStatus&#x60; value as defined in the 3D Secure 2 specification.
   * @return whiteListStatus
  **/
  @ApiModelProperty(value = "The `whiteListStatus` value as defined in the 3D Secure 2 specification.")
  @JsonProperty(JSON_PROPERTY_WHITE_LIST_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhiteListStatus() {
    return whiteListStatus;
  }


 /**
  * The &#x60;whiteListStatus&#x60; value as defined in the 3D Secure 2 specification.
  *
  * @param whiteListStatus
  */ 
  @JsonProperty(JSON_PROPERTY_WHITE_LIST_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
  }


  /**
   * Return true if this ThreeDS2Result object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreeDS2Result threeDS2Result = (ThreeDS2Result) o;
    return Objects.equals(this.authenticationValue, threeDS2Result.authenticationValue) &&
        Objects.equals(this.cavvAlgorithm, threeDS2Result.cavvAlgorithm) &&
        Objects.equals(this.challengeCancel, threeDS2Result.challengeCancel) &&
        Objects.equals(this.dsTransID, threeDS2Result.dsTransID) &&
        Objects.equals(this.eci, threeDS2Result.eci) &&
        Objects.equals(this.exemptionIndicator, threeDS2Result.exemptionIndicator) &&
        Objects.equals(this.messageVersion, threeDS2Result.messageVersion) &&
        Objects.equals(this.riskScore, threeDS2Result.riskScore) &&
        Objects.equals(this.threeDSRequestorChallengeInd, threeDS2Result.threeDSRequestorChallengeInd) &&
        Objects.equals(this.threeDSServerTransID, threeDS2Result.threeDSServerTransID) &&
        Objects.equals(this.timestamp, threeDS2Result.timestamp) &&
        Objects.equals(this.transStatus, threeDS2Result.transStatus) &&
        Objects.equals(this.transStatusReason, threeDS2Result.transStatusReason) &&
        Objects.equals(this.whiteListStatus, threeDS2Result.whiteListStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationValue, cavvAlgorithm, challengeCancel, dsTransID, eci, exemptionIndicator, messageVersion, riskScore, threeDSRequestorChallengeInd, threeDSServerTransID, timestamp, transStatus, transStatusReason, whiteListStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreeDS2Result {\n");
    sb.append("    authenticationValue: ").append(toIndentedString(authenticationValue)).append("\n");
    sb.append("    cavvAlgorithm: ").append(toIndentedString(cavvAlgorithm)).append("\n");
    sb.append("    challengeCancel: ").append(toIndentedString(challengeCancel)).append("\n");
    sb.append("    dsTransID: ").append(toIndentedString(dsTransID)).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    exemptionIndicator: ").append(toIndentedString(exemptionIndicator)).append("\n");
    sb.append("    messageVersion: ").append(toIndentedString(messageVersion)).append("\n");
    sb.append("    riskScore: ").append(toIndentedString(riskScore)).append("\n");
    sb.append("    threeDSRequestorChallengeInd: ").append(toIndentedString(threeDSRequestorChallengeInd)).append("\n");
    sb.append("    threeDSServerTransID: ").append(toIndentedString(threeDSServerTransID)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    transStatus: ").append(toIndentedString(transStatus)).append("\n");
    sb.append("    transStatusReason: ").append(toIndentedString(transStatusReason)).append("\n");
    sb.append("    whiteListStatus: ").append(toIndentedString(whiteListStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ThreeDS2Result given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ThreeDS2Result
   * @throws JsonProcessingException if the JSON string is invalid with respect to ThreeDS2Result
   */
  public static ThreeDS2Result fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ThreeDS2Result.class);
  }
/**
  * Convert an instance of ThreeDS2Result to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

