/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpaywebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * UltimateParentCompanyBusinessDetails
 */
@JsonPropertyOrder({
  UltimateParentCompanyBusinessDetails.JSON_PROPERTY_LEGAL_BUSINESS_NAME,
  UltimateParentCompanyBusinessDetails.JSON_PROPERTY_REGISTRATION_NUMBER,
  UltimateParentCompanyBusinessDetails.JSON_PROPERTY_STOCK_EXCHANGE,
  UltimateParentCompanyBusinessDetails.JSON_PROPERTY_STOCK_NUMBER,
  UltimateParentCompanyBusinessDetails.JSON_PROPERTY_STOCK_TICKER
})

public class UltimateParentCompanyBusinessDetails {
  public static final String JSON_PROPERTY_LEGAL_BUSINESS_NAME = "legalBusinessName";
  private String legalBusinessName;

  public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
  private String registrationNumber;

  public static final String JSON_PROPERTY_STOCK_EXCHANGE = "stockExchange";
  private String stockExchange;

  public static final String JSON_PROPERTY_STOCK_NUMBER = "stockNumber";
  private String stockNumber;

  public static final String JSON_PROPERTY_STOCK_TICKER = "stockTicker";
  private String stockTicker;

  public UltimateParentCompanyBusinessDetails() { 
  }

  public UltimateParentCompanyBusinessDetails legalBusinessName(String legalBusinessName) {
    this.legalBusinessName = legalBusinessName;
    return this;
  }

   /**
   * The legal name of the company.
   * @return legalBusinessName
  **/
  @ApiModelProperty(value = "The legal name of the company.")
  @JsonProperty(JSON_PROPERTY_LEGAL_BUSINESS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalBusinessName() {
    return legalBusinessName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_BUSINESS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalBusinessName(String legalBusinessName) {
    this.legalBusinessName = legalBusinessName;
  }


  public UltimateParentCompanyBusinessDetails registrationNumber(String registrationNumber) {
    this.registrationNumber = registrationNumber;
    return this;
  }

   /**
   * The registration number of the company.
   * @return registrationNumber
  **/
  @ApiModelProperty(value = "The registration number of the company.")
  @JsonProperty(JSON_PROPERTY_REGISTRATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRegistrationNumber() {
    return registrationNumber;
  }


  @JsonProperty(JSON_PROPERTY_REGISTRATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegistrationNumber(String registrationNumber) {
    this.registrationNumber = registrationNumber;
  }


  public UltimateParentCompanyBusinessDetails stockExchange(String stockExchange) {
    this.stockExchange = stockExchange;
    return this;
  }

   /**
   * Market Identifier Code (MIC).
   * @return stockExchange
  **/
  @ApiModelProperty(value = "Market Identifier Code (MIC).")
  @JsonProperty(JSON_PROPERTY_STOCK_EXCHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStockExchange() {
    return stockExchange;
  }


  @JsonProperty(JSON_PROPERTY_STOCK_EXCHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockExchange(String stockExchange) {
    this.stockExchange = stockExchange;
  }


  public UltimateParentCompanyBusinessDetails stockNumber(String stockNumber) {
    this.stockNumber = stockNumber;
    return this;
  }

   /**
   * International Securities Identification Number (ISIN).
   * @return stockNumber
  **/
  @ApiModelProperty(value = "International Securities Identification Number (ISIN).")
  @JsonProperty(JSON_PROPERTY_STOCK_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStockNumber() {
    return stockNumber;
  }


  @JsonProperty(JSON_PROPERTY_STOCK_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockNumber(String stockNumber) {
    this.stockNumber = stockNumber;
  }


  public UltimateParentCompanyBusinessDetails stockTicker(String stockTicker) {
    this.stockTicker = stockTicker;
    return this;
  }

   /**
   * Stock Ticker symbol.
   * @return stockTicker
  **/
  @ApiModelProperty(value = "Stock Ticker symbol.")
  @JsonProperty(JSON_PROPERTY_STOCK_TICKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStockTicker() {
    return stockTicker;
  }


  @JsonProperty(JSON_PROPERTY_STOCK_TICKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockTicker(String stockTicker) {
    this.stockTicker = stockTicker;
  }


  /**
   * Return true if this UltimateParentCompanyBusinessDetails object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UltimateParentCompanyBusinessDetails ultimateParentCompanyBusinessDetails = (UltimateParentCompanyBusinessDetails) o;
    return Objects.equals(this.legalBusinessName, ultimateParentCompanyBusinessDetails.legalBusinessName) &&
        Objects.equals(this.registrationNumber, ultimateParentCompanyBusinessDetails.registrationNumber) &&
        Objects.equals(this.stockExchange, ultimateParentCompanyBusinessDetails.stockExchange) &&
        Objects.equals(this.stockNumber, ultimateParentCompanyBusinessDetails.stockNumber) &&
        Objects.equals(this.stockTicker, ultimateParentCompanyBusinessDetails.stockTicker);
  }

  @Override
  public int hashCode() {
    return Objects.hash(legalBusinessName, registrationNumber, stockExchange, stockNumber, stockTicker);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UltimateParentCompanyBusinessDetails {\n");
    sb.append("    legalBusinessName: ").append(toIndentedString(legalBusinessName)).append("\n");
    sb.append("    registrationNumber: ").append(toIndentedString(registrationNumber)).append("\n");
    sb.append("    stockExchange: ").append(toIndentedString(stockExchange)).append("\n");
    sb.append("    stockNumber: ").append(toIndentedString(stockNumber)).append("\n");
    sb.append("    stockTicker: ").append(toIndentedString(stockTicker)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of UltimateParentCompanyBusinessDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UltimateParentCompanyBusinessDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to UltimateParentCompanyBusinessDetails
   */
  public static UltimateParentCompanyBusinessDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UltimateParentCompanyBusinessDetails.class);
  }
/**
  * Convert an instance of UltimateParentCompanyBusinessDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

