/*
 * Notification Configuration API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Notification Configuration API provides endpoints for setting up and testing notifications that inform you of events on your platform, for example when a verification check or a payout has been completed.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/notifications). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Notification Configuration API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Notification/v6/createNotificationConfiguration ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayconfiguration;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DeleteNotificationConfigurationRequest
 */
@JsonPropertyOrder({
  DeleteNotificationConfigurationRequest.JSON_PROPERTY_NOTIFICATION_IDS
})

public class DeleteNotificationConfigurationRequest {
  public static final String JSON_PROPERTY_NOTIFICATION_IDS = "notificationIds";
  private List<Long> notificationIds = new ArrayList<>();

  public DeleteNotificationConfigurationRequest() { 
  }

  public DeleteNotificationConfigurationRequest notificationIds(List<Long> notificationIds) {
    this.notificationIds = notificationIds;
    return this;
  }

  public DeleteNotificationConfigurationRequest addNotificationIdsItem(Long notificationIdsItem) {
    this.notificationIds.add(notificationIdsItem);
    return this;
  }

   /**
   * A list of IDs of the notification subscription configurations to be deleted.
   * @return notificationIds
  **/
  @ApiModelProperty(required = true, value = "A list of IDs of the notification subscription configurations to be deleted.")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Long> getNotificationIds() {
    return notificationIds;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationIds(List<Long> notificationIds) {
    this.notificationIds = notificationIds;
  }


  /**
   * Return true if this DeleteNotificationConfigurationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest = (DeleteNotificationConfigurationRequest) o;
    return Objects.equals(this.notificationIds, deleteNotificationConfigurationRequest.notificationIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(notificationIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeleteNotificationConfigurationRequest {\n");
    sb.append("    notificationIds: ").append(toIndentedString(notificationIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DeleteNotificationConfigurationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DeleteNotificationConfigurationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to DeleteNotificationConfigurationRequest
   */
  public static DeleteNotificationConfigurationRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DeleteNotificationConfigurationRequest.class);
  }
/**
  * Convert an instance of DeleteNotificationConfigurationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

