/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.OrderItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TerminalOrderRequest
 */
@JsonPropertyOrder({
  TerminalOrderRequest.JSON_PROPERTY_BILLING_ENTITY_ID,
  TerminalOrderRequest.JSON_PROPERTY_CUSTOMER_ORDER_REFERENCE,
  TerminalOrderRequest.JSON_PROPERTY_ITEMS,
  TerminalOrderRequest.JSON_PROPERTY_ORDER_TYPE,
  TerminalOrderRequest.JSON_PROPERTY_SHIPPING_LOCATION_ID,
  TerminalOrderRequest.JSON_PROPERTY_TAX_ID
})

public class TerminalOrderRequest {
  public static final String JSON_PROPERTY_BILLING_ENTITY_ID = "billingEntityId";
  private String billingEntityId;

  public static final String JSON_PROPERTY_CUSTOMER_ORDER_REFERENCE = "customerOrderReference";
  private String customerOrderReference;

  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<OrderItem> items = null;

  public static final String JSON_PROPERTY_ORDER_TYPE = "orderType";
  private String orderType;

  public static final String JSON_PROPERTY_SHIPPING_LOCATION_ID = "shippingLocationId";
  private String shippingLocationId;

  public static final String JSON_PROPERTY_TAX_ID = "taxId";
  private String taxId;

  public TerminalOrderRequest() { 
  }

  public TerminalOrderRequest billingEntityId(String billingEntityId) {
    this.billingEntityId = billingEntityId;
    return this;
  }

   /**
   * The identification of the billing entity to use for the order.
   * @return billingEntityId
  **/
  @ApiModelProperty(value = "The identification of the billing entity to use for the order.")
  @JsonProperty(JSON_PROPERTY_BILLING_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingEntityId() {
    return billingEntityId;
  }


 /**
  * The identification of the billing entity to use for the order.
  *
  * @param billingEntityId
  */ 
  @JsonProperty(JSON_PROPERTY_BILLING_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingEntityId(String billingEntityId) {
    this.billingEntityId = billingEntityId;
  }


  public TerminalOrderRequest customerOrderReference(String customerOrderReference) {
    this.customerOrderReference = customerOrderReference;
    return this;
  }

   /**
   * The merchant-defined purchase order reference.
   * @return customerOrderReference
  **/
  @ApiModelProperty(value = "The merchant-defined purchase order reference.")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerOrderReference() {
    return customerOrderReference;
  }


 /**
  * The merchant-defined purchase order reference.
  *
  * @param customerOrderReference
  */ 
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerOrderReference(String customerOrderReference) {
    this.customerOrderReference = customerOrderReference;
  }


  public TerminalOrderRequest items(List<OrderItem> items) {
    this.items = items;
    return this;
  }

  public TerminalOrderRequest addItemsItem(OrderItem itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * The products included in the order.
   * @return items
  **/
  @ApiModelProperty(value = "The products included in the order.")
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderItem> getItems() {
    return items;
  }


 /**
  * The products included in the order.
  *
  * @param items
  */ 
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItems(List<OrderItem> items) {
    this.items = items;
  }


  public TerminalOrderRequest orderType(String orderType) {
    this.orderType = orderType;
    return this;
  }

   /**
   * Type of order
   * @return orderType
  **/
  @ApiModelProperty(value = "Type of order")
  @JsonProperty(JSON_PROPERTY_ORDER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderType() {
    return orderType;
  }


 /**
  * Type of order
  *
  * @param orderType
  */ 
  @JsonProperty(JSON_PROPERTY_ORDER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderType(String orderType) {
    this.orderType = orderType;
  }


  public TerminalOrderRequest shippingLocationId(String shippingLocationId) {
    this.shippingLocationId = shippingLocationId;
    return this;
  }

   /**
   * The identification of the shipping location to use for the order.
   * @return shippingLocationId
  **/
  @ApiModelProperty(value = "The identification of the shipping location to use for the order.")
  @JsonProperty(JSON_PROPERTY_SHIPPING_LOCATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShippingLocationId() {
    return shippingLocationId;
  }


 /**
  * The identification of the shipping location to use for the order.
  *
  * @param shippingLocationId
  */ 
  @JsonProperty(JSON_PROPERTY_SHIPPING_LOCATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingLocationId(String shippingLocationId) {
    this.shippingLocationId = shippingLocationId;
  }


  public TerminalOrderRequest taxId(String taxId) {
    this.taxId = taxId;
    return this;
  }

   /**
   * The tax number of the billing entity.
   * @return taxId
  **/
  @ApiModelProperty(value = "The tax number of the billing entity.")
  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTaxId() {
    return taxId;
  }


 /**
  * The tax number of the billing entity.
  *
  * @param taxId
  */ 
  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxId(String taxId) {
    this.taxId = taxId;
  }


  /**
   * Return true if this TerminalOrderRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalOrderRequest terminalOrderRequest = (TerminalOrderRequest) o;
    return Objects.equals(this.billingEntityId, terminalOrderRequest.billingEntityId) &&
        Objects.equals(this.customerOrderReference, terminalOrderRequest.customerOrderReference) &&
        Objects.equals(this.items, terminalOrderRequest.items) &&
        Objects.equals(this.orderType, terminalOrderRequest.orderType) &&
        Objects.equals(this.shippingLocationId, terminalOrderRequest.shippingLocationId) &&
        Objects.equals(this.taxId, terminalOrderRequest.taxId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billingEntityId, customerOrderReference, items, orderType, shippingLocationId, taxId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalOrderRequest {\n");
    sb.append("    billingEntityId: ").append(toIndentedString(billingEntityId)).append("\n");
    sb.append("    customerOrderReference: ").append(toIndentedString(customerOrderReference)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    orderType: ").append(toIndentedString(orderType)).append("\n");
    sb.append("    shippingLocationId: ").append(toIndentedString(shippingLocationId)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TerminalOrderRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TerminalOrderRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to TerminalOrderRequest
   */
  public static TerminalOrderRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TerminalOrderRequest.class);
  }
/**
  * Convert an instance of TerminalOrderRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

