/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * OnboardingTheme
 */
@JsonPropertyOrder({
  OnboardingTheme.JSON_PROPERTY_CREATED_AT,
  OnboardingTheme.JSON_PROPERTY_DESCRIPTION,
  OnboardingTheme.JSON_PROPERTY_ID,
  OnboardingTheme.JSON_PROPERTY_PROPERTIES,
  OnboardingTheme.JSON_PROPERTY_UPDATED_AT
})

public class OnboardingTheme {
  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, String> properties = new HashMap<>();

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public OnboardingTheme() { 
  }

  public OnboardingTheme createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The creation date of the theme.
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "The creation date of the theme.")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


 /**
  * The creation date of the theme.
  *
  * @param createdAt
  */ 
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public OnboardingTheme description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the theme.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the theme.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


 /**
  * The description of the theme.
  *
  * @param description
  */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public OnboardingTheme id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the theme.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The unique identifier of the theme.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * The unique identifier of the theme.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OnboardingTheme properties(Map<String, String> properties) {
    this.properties = properties;
    return this;
  }

  public OnboardingTheme putPropertiesItem(String key, String propertiesItem) {
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * The properties of the theme.
   * @return properties
  **/
  @ApiModelProperty(required = true, value = "The properties of the theme.")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getProperties() {
    return properties;
  }


 /**
  * The properties of the theme.
  *
  * @param properties
  */ 
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProperties(Map<String, String> properties) {
    this.properties = properties;
  }


  public OnboardingTheme updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The date when the theme was last updated.
   * @return updatedAt
  **/
  @ApiModelProperty(value = "The date when the theme was last updated.")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


 /**
  * The date when the theme was last updated.
  *
  * @param updatedAt
  */ 
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  /**
   * Return true if this OnboardingTheme object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OnboardingTheme onboardingTheme = (OnboardingTheme) o;
    return Objects.equals(this.createdAt, onboardingTheme.createdAt) &&
        Objects.equals(this.description, onboardingTheme.description) &&
        Objects.equals(this.id, onboardingTheme.id) &&
        Objects.equals(this.properties, onboardingTheme.properties) &&
        Objects.equals(this.updatedAt, onboardingTheme.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, description, id, properties, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OnboardingTheme {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of OnboardingTheme given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of OnboardingTheme
   * @throws JsonProcessingException if the JSON string is invalid with respect to OnboardingTheme
   */
  public static OnboardingTheme fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, OnboardingTheme.class);
  }
/**
  * Convert an instance of OnboardingTheme to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

