/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.balanceplatform.RepaymentTerm;
import com.adyen.model.balanceplatform.ThresholdRepayment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Repayment
 */
@JsonPropertyOrder({
  Repayment.JSON_PROPERTY_BASIS_POINTS,
  Repayment.JSON_PROPERTY_TERM,
  Repayment.JSON_PROPERTY_THRESHOLD
})

public class Repayment {
  public static final String JSON_PROPERTY_BASIS_POINTS = "basisPoints";
  private Integer basisPoints;

  public static final String JSON_PROPERTY_TERM = "term";
  private RepaymentTerm term;

  public static final String JSON_PROPERTY_THRESHOLD = "threshold";
  private ThresholdRepayment threshold;

  public Repayment() { 
  }

  public Repayment basisPoints(Integer basisPoints) {
    this.basisPoints = basisPoints;
    return this;
  }

   /**
   * The repayment that is deducted daily from incoming net volume, in [basis points](https://www.investopedia.com/terms/b/basispoint.asp).
   * @return basisPoints
  **/
  @ApiModelProperty(required = true, value = "The repayment that is deducted daily from incoming net volume, in [basis points](https://www.investopedia.com/terms/b/basispoint.asp).")
  @JsonProperty(JSON_PROPERTY_BASIS_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBasisPoints() {
    return basisPoints;
  }


 /**
  * The repayment that is deducted daily from incoming net volume, in [basis points](https://www.investopedia.com/terms/b/basispoint.asp).
  *
  * @param basisPoints
  */ 
  @JsonProperty(JSON_PROPERTY_BASIS_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBasisPoints(Integer basisPoints) {
    this.basisPoints = basisPoints;
  }


  public Repayment term(RepaymentTerm term) {
    this.term = term;
    return this;
  }

   /**
   * Get term
   * @return term
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TERM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RepaymentTerm getTerm() {
    return term;
  }


 /**
  * term
  *
  * @param term
  */ 
  @JsonProperty(JSON_PROPERTY_TERM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerm(RepaymentTerm term) {
    this.term = term;
  }


  public Repayment threshold(ThresholdRepayment threshold) {
    this.threshold = threshold;
    return this;
  }

   /**
   * Get threshold
   * @return threshold
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THRESHOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThresholdRepayment getThreshold() {
    return threshold;
  }


 /**
  * threshold
  *
  * @param threshold
  */ 
  @JsonProperty(JSON_PROPERTY_THRESHOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreshold(ThresholdRepayment threshold) {
    this.threshold = threshold;
  }


  /**
   * Return true if this Repayment object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Repayment repayment = (Repayment) o;
    return Objects.equals(this.basisPoints, repayment.basisPoints) &&
        Objects.equals(this.term, repayment.term) &&
        Objects.equals(this.threshold, repayment.threshold);
  }

  @Override
  public int hashCode() {
    return Objects.hash(basisPoints, term, threshold);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Repayment {\n");
    sb.append("    basisPoints: ").append(toIndentedString(basisPoints)).append("\n");
    sb.append("    term: ").append(toIndentedString(term)).append("\n");
    sb.append("    threshold: ").append(toIndentedString(threshold)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Repayment given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Repayment
   * @throws JsonProcessingException if the JSON string is invalid with respect to Repayment
   */
  public static Repayment fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Repayment.class);
  }
/**
  * Convert an instance of Repayment to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

