/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.PaginationLinks;
import com.adyen.model.management.PaymentMethod;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "data", "itemsTotal", "pagesTotal", "typesWithErrors"})
public class PaymentMethodResponse {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private PaginationLinks links;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<PaymentMethod> data = null;
    public static final String JSON_PROPERTY_ITEMS_TOTAL = "itemsTotal";
    private Integer itemsTotal;
    public static final String JSON_PROPERTY_PAGES_TOTAL = "pagesTotal";
    private Integer pagesTotal;
    public static final String JSON_PROPERTY_TYPES_WITH_ERRORS = "typesWithErrors";
    private List<TypesWithErrorsEnum> typesWithErrors = null;

    public PaymentMethodResponse links(PaginationLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaginationLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(PaginationLinks links) {
        this.links = links;
    }

    public PaymentMethodResponse data(List<PaymentMethod> data) {
        this.data = data;
        return this;
    }

    public PaymentMethodResponse addDataItem(PaymentMethod dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<PaymentMethod>();
        }
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(value="The list of supported payment methods and their details.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethod> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(List<PaymentMethod> data) {
        this.data = data;
    }

    public PaymentMethodResponse itemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of items.")
    @JsonProperty(value="itemsTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    @JsonProperty(value="itemsTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
    }

    public PaymentMethodResponse pagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of pages.")
    @JsonProperty(value="pagesTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    @JsonProperty(value="pagesTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
    }

    public PaymentMethodResponse typesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
        this.typesWithErrors = typesWithErrors;
        return this;
    }

    public PaymentMethodResponse addTypesWithErrorsItem(TypesWithErrorsEnum typesWithErrorsItem) {
        if (this.typesWithErrors == null) {
            this.typesWithErrors = new ArrayList<TypesWithErrorsEnum>();
        }
        this.typesWithErrors.add(typesWithErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Payment method types with errors.")
    @JsonProperty(value="typesWithErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TypesWithErrorsEnum> getTypesWithErrors() {
        return this.typesWithErrors;
    }

    @JsonProperty(value="typesWithErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
        this.typesWithErrors = typesWithErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodResponse paymentMethodResponse = (PaymentMethodResponse)o;
        return Objects.equals(this.links, paymentMethodResponse.links) && Objects.equals(this.data, paymentMethodResponse.data) && Objects.equals(this.itemsTotal, paymentMethodResponse.itemsTotal) && Objects.equals(this.pagesTotal, paymentMethodResponse.pagesTotal) && Objects.equals(this.typesWithErrors, paymentMethodResponse.typesWithErrors);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.data, this.itemsTotal, this.pagesTotal, this.typesWithErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    pagesTotal: ").append(this.toIndentedString(this.pagesTotal)).append("\n");
        sb.append("    typesWithErrors: ").append(this.toIndentedString(this.typesWithErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethodResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethodResponse)JSON.getMapper().readValue(jsonString, PaymentMethodResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypesWithErrorsEnum {
        AFTERPAYTOUCH("afterpaytouch"),
        ALIPAY("alipay"),
        ALIPAY_HK("alipay_hk"),
        AMEX("amex"),
        APPLEPAY("applepay"),
        BCMC("bcmc"),
        BLIK("blik"),
        CARTEBANCAIRE("cartebancaire"),
        CLEARPAY("clearpay"),
        CUP("cup"),
        DINERS("diners"),
        DIRECTDEBIT_GB("directdebit_GB"),
        DISCOVER("discover"),
        EBANKING_FI("ebanking_FI"),
        EFTPOS_AUSTRALIA("eftpos_australia"),
        ELO("elo"),
        ELOCREDIT("elocredit"),
        ELODEBIT("elodebit"),
        GIROCARD("girocard"),
        GOOGLEPAY("googlepay"),
        HIPER("hiper"),
        HIPERCARD("hipercard"),
        IDEAL("ideal"),
        INTERAC_CARD("interac_card"),
        JCB("jcb"),
        KLARNA("klarna"),
        KLARNA_ACCOUNT("klarna_account"),
        KLARNA_PAYNOW("klarna_paynow"),
        MAESTRO("maestro"),
        MBWAY("mbway"),
        MC("mc"),
        MCDEBIT("mcdebit"),
        MEALVOUCHER_FR("mealVoucher_FR"),
        MOBILEPAY("mobilepay"),
        MULTIBANCO("multibanco"),
        ONLINEBANKING_PL("onlineBanking_PL"),
        PAYBYBANK("paybybank"),
        PAYPAL("paypal"),
        PAYSHOP("payshop"),
        SWISH("swish"),
        TRUSTLY("trustly"),
        TWINT("twint"),
        TWINT_POS("twint_pos"),
        VIPPS("vipps"),
        VISA("visa"),
        VISADEBIT("visadebit"),
        VPAY("vpay"),
        WECHATPAY("wechatpay"),
        WECHATPAY_POS("wechatpay_pos");

        private String value;

        private TypesWithErrorsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypesWithErrorsEnum fromValue(String value) {
            for (TypesWithErrorsEnum b : TypesWithErrorsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

