/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.CompanyUser;
import com.adyen.model.management.CreateCompanyUserRequest;
import com.adyen.model.management.CreateCompanyUserResponse;
import com.adyen.model.management.ListCompanyUsersResponse;
import com.adyen.model.management.UpdateCompanyUserRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class UsersCompanyLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public UsersCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public UsersCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public ListCompanyUsersResponse listUsers(String companyId) throws ApiException, IOException {
        return this.listUsers(companyId, null, null, null, null);
    }

    public ListCompanyUsersResponse listUsers(String companyId, Integer pageNumber, Integer pageSize, String username, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (username != null) {
            queryParams.put("username", username);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/users", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListCompanyUsersResponse.fromJson(jsonResult);
    }

    public CompanyUser getUserDetails(String companyId, String userId) throws ApiException, IOException {
        return this.getUserDetails(companyId, userId, null);
    }

    public CompanyUser getUserDetails(String companyId, String userId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (userId == null) {
            throw new IllegalArgumentException("Please provide the userId path parameter");
        }
        pathParams.put("userId", userId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/users/{userId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return CompanyUser.fromJson(jsonResult);
    }

    public CompanyUser updateUserDetails(String companyId, String userId, UpdateCompanyUserRequest updateCompanyUserRequest) throws ApiException, IOException {
        return this.updateUserDetails(companyId, userId, updateCompanyUserRequest, null);
    }

    public CompanyUser updateUserDetails(String companyId, String userId, UpdateCompanyUserRequest updateCompanyUserRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (userId == null) {
            throw new IllegalArgumentException("Please provide the userId path parameter");
        }
        pathParams.put("userId", userId);
        String requestBody = updateCompanyUserRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/users/{userId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return CompanyUser.fromJson(jsonResult);
    }

    public CreateCompanyUserResponse createNewUser(String companyId, CreateCompanyUserRequest createCompanyUserRequest) throws ApiException, IOException {
        return this.createNewUser(companyId, createCompanyUserRequest, null);
    }

    public CreateCompanyUserResponse createNewUser(String companyId, CreateCompanyUserRequest createCompanyUserRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = createCompanyUserRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/users", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return CreateCompanyUserResponse.fromJson(jsonResult);
    }
}

