/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.BillingEntitiesResponse;
import com.adyen.model.management.ShippingLocation;
import com.adyen.model.management.ShippingLocationsResponse;
import com.adyen.model.management.TerminalModelsResponse;
import com.adyen.model.management.TerminalOrder;
import com.adyen.model.management.TerminalOrderRequest;
import com.adyen.model.management.TerminalOrdersResponse;
import com.adyen.model.management.TerminalProductsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalOrdersCompanyLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TerminalOrdersCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public TerminalOrdersCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public BillingEntitiesResponse listBillingEntities(String companyId) throws ApiException, IOException {
        return this.listBillingEntities(companyId, null, null);
    }

    public BillingEntitiesResponse listBillingEntities(String companyId, String name, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (name != null) {
            queryParams.put("name", name);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/billingEntities", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return BillingEntitiesResponse.fromJson(jsonResult);
    }

    public ShippingLocationsResponse listShippingLocations(String companyId) throws ApiException, IOException {
        return this.listShippingLocations(companyId, null, null, null, null);
    }

    public ShippingLocationsResponse listShippingLocations(String companyId, String name, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (name != null) {
            queryParams.put("name", name);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/shippingLocations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ShippingLocationsResponse.fromJson(jsonResult);
    }

    public TerminalModelsResponse listTerminalModels(String companyId) throws ApiException, IOException {
        return this.listTerminalModels(companyId, null);
    }

    public TerminalModelsResponse listTerminalModels(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalModels", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalModelsResponse.fromJson(jsonResult);
    }

    public TerminalOrdersResponse listOrders(String companyId) throws ApiException, IOException {
        return this.listOrders(companyId, null, null, null, null, null);
    }

    public TerminalOrdersResponse listOrders(String companyId, String customerOrderReference, String status, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (customerOrderReference != null) {
            queryParams.put("customerOrderReference", customerOrderReference);
        }
        if (status != null) {
            queryParams.put("status", status);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalOrders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TerminalOrdersResponse.fromJson(jsonResult);
    }

    public TerminalOrder getOrder(String companyId, String orderId) throws ApiException, IOException {
        return this.getOrder(companyId, orderId, null);
    }

    public TerminalOrder getOrder(String companyId, String orderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (orderId == null) {
            throw new IllegalArgumentException("Please provide the orderId path parameter");
        }
        pathParams.put("orderId", orderId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalOrders/{orderId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public TerminalProductsResponse listTerminalProducts(String companyId, String country) throws ApiException, IOException {
        return this.listTerminalProducts(companyId, country, null, null, null, null);
    }

    public TerminalProductsResponse listTerminalProducts(String companyId, String country, String terminalModelId, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (country != null) {
            queryParams.put("country", country);
        }
        if (terminalModelId != null) {
            queryParams.put("terminalModelId", terminalModelId);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalProducts", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TerminalProductsResponse.fromJson(jsonResult);
    }

    public TerminalOrder updateOrder(String companyId, String orderId, TerminalOrderRequest terminalOrderRequest) throws ApiException, IOException {
        return this.updateOrder(companyId, orderId, terminalOrderRequest, null);
    }

    public TerminalOrder updateOrder(String companyId, String orderId, TerminalOrderRequest terminalOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (orderId == null) {
            throw new IllegalArgumentException("Please provide the orderId path parameter");
        }
        pathParams.put("orderId", orderId);
        String requestBody = terminalOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalOrders/{orderId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public ShippingLocation createShippingLocation(String companyId, ShippingLocation shippingLocation) throws ApiException, IOException {
        return this.createShippingLocation(companyId, shippingLocation, null);
    }

    public ShippingLocation createShippingLocation(String companyId, ShippingLocation shippingLocation, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = shippingLocation.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/shippingLocations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return ShippingLocation.fromJson(jsonResult);
    }

    public TerminalOrder createOrder(String companyId, TerminalOrderRequest terminalOrderRequest) throws ApiException, IOException {
        return this.createOrder(companyId, terminalOrderRequest, null);
    }

    public TerminalOrder createOrder(String companyId, TerminalOrderRequest terminalOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = terminalOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalOrders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public TerminalOrder cancelOrder(String companyId, String orderId) throws ApiException, IOException {
        return this.cancelOrder(companyId, orderId, null);
    }

    public TerminalOrder cancelOrder(String companyId, String orderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (orderId == null) {
            throw new IllegalArgumentException("Please provide the orderId path parameter");
        }
        pathParams.put("orderId", orderId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalOrders/{orderId}/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }
}

