/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "amount", "transferDate"})
public class CompensateNegativeBalanceNotificationRecord {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_TRANSFER_DATE = "transferDate";
    private OffsetDateTime transferDate;

    public CompensateNegativeBalanceNotificationRecord accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account whose negative balance has been compensated.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public CompensateNegativeBalanceNotificationRecord amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CompensateNegativeBalanceNotificationRecord transferDate(OffsetDateTime transferDate) {
        this.transferDate = transferDate;
        return this;
    }

    @ApiModelProperty(value="The date on which the compensation took place.")
    @JsonProperty(value="transferDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTransferDate() {
        return this.transferDate;
    }

    @JsonProperty(value="transferDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferDate(OffsetDateTime transferDate) {
        this.transferDate = transferDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompensateNegativeBalanceNotificationRecord compensateNegativeBalanceNotificationRecord = (CompensateNegativeBalanceNotificationRecord)o;
        return Objects.equals(this.accountCode, compensateNegativeBalanceNotificationRecord.accountCode) && Objects.equals(this.amount, compensateNegativeBalanceNotificationRecord.amount) && Objects.equals(this.transferDate, compensateNegativeBalanceNotificationRecord.transferDate);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.amount, this.transferDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompensateNegativeBalanceNotificationRecord {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    transferDate: ").append(this.toIndentedString(this.transferDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CompensateNegativeBalanceNotificationRecord fromJson(String jsonString) throws JsonProcessingException {
        return (CompensateNegativeBalanceNotificationRecord)JSON.getMapper().readValue(jsonString, CompensateNegativeBalanceNotificationRecord.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

