/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.Fee;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.Repayment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderId", "amount", "contractType", "expiresAt", "fee", "id", "repayment", "startsAt"})
public class GrantOffer {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
    private String accountHolderId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_CONTRACT_TYPE = "contractType";
    private ContractTypeEnum contractType;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private Object expiresAt;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Fee fee;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_REPAYMENT = "repayment";
    private Repayment repayment;
    public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
    private Object startsAt;

    public GrantOffer accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the account holder to which the grant is offered.")
    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public GrantOffer amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public GrantOffer contractType(ContractTypeEnum contractType) {
        this.contractType = contractType;
        return this;
    }

    @ApiModelProperty(value="The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.")
    @JsonProperty(value="contractType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContractTypeEnum getContractType() {
        return this.contractType;
    }

    @JsonProperty(value="contractType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContractType(ContractTypeEnum contractType) {
        this.contractType = contractType;
    }

    public GrantOffer expiresAt(Object expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(Object expiresAt) {
        this.expiresAt = expiresAt;
    }

    public GrantOffer fee(Fee fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Fee getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Fee fee) {
        this.fee = fee;
    }

    public GrantOffer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the grant offer.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public GrantOffer repayment(Repayment repayment) {
        this.repayment = repayment;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Repayment getRepayment() {
        return this.repayment;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRepayment(Repayment repayment) {
        this.repayment = repayment;
    }

    public GrantOffer startsAt(Object startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartsAt(Object startsAt) {
        this.startsAt = startsAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantOffer grantOffer = (GrantOffer)o;
        return Objects.equals(this.accountHolderId, grantOffer.accountHolderId) && Objects.equals(this.amount, grantOffer.amount) && Objects.equals((Object)this.contractType, (Object)grantOffer.contractType) && Objects.equals(this.expiresAt, grantOffer.expiresAt) && Objects.equals(this.fee, grantOffer.fee) && Objects.equals(this.id, grantOffer.id) && Objects.equals(this.repayment, grantOffer.repayment) && Objects.equals(this.startsAt, grantOffer.startsAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.amount, this.contractType, this.expiresAt, this.fee, this.id, this.repayment, this.startsAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrantOffer {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    contractType: ").append(this.toIndentedString((Object)this.contractType)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    repayment: ").append(this.toIndentedString(this.repayment)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GrantOffer fromJson(String jsonString) throws JsonProcessingException {
        return (GrantOffer)JSON.getMapper().readValue(jsonString, GrantOffer.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ContractTypeEnum {
        CASHADVANCE("cashAdvance"),
        LOAN("loan");

        private String value;

        private ContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContractTypeEnum fromValue(String value) {
            for (ContractTypeEnum b : ContractTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

