/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.Logo;
import com.adyen.model.management.RestServiceError;
import com.adyen.model.management.TerminalSettings;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TerminalSettingsStoreLevelApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * Terminal settings - store level constructor in {@link com.adyen.service.management package}.
    * @param client {@link Client } (required)
    */
    public TerminalSettingsStoreLevelApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://management-test.adyen.com/v3");
    }

    /**
    * Terminal settings - store level constructor in {@link com.adyen.service.management package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public TerminalSettingsStoreLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Get the terminal logo
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param model {@link String } The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T. (required)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo getTerminalLogo(String merchantId, String reference, String model) throws ApiException, IOException {
        return getTerminalLogo(merchantId, reference, model,  null);
    }

    /**
    * Get the terminal logo
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param model {@link String } Query: The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo getTerminalLogo(String merchantId, String reference, String model, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (model != null) {
        queryParams.put("model", model);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    /**
    * Get terminal settings
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings getTerminalSettings(String merchantId, String reference) throws ApiException, IOException {
        return getTerminalSettings(merchantId, reference, null);
    }

    /**
    * Get terminal settings
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings getTerminalSettings(String merchantId, String reference, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    /**
    * Get the terminal logo
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param model {@link String } The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T. (required)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo getTerminalLogoByStoreId(String storeId, String model) throws ApiException, IOException {
        return getTerminalLogoByStoreId(storeId, model,  null);
    }

    /**
    * Get the terminal logo
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param model {@link String } Query: The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo getTerminalLogoByStoreId(String storeId, String model, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (model != null) {
        queryParams.put("model", model);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    /**
    * Get terminal settings
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings getTerminalSettingsByStoreId(String storeId) throws ApiException, IOException {
        return getTerminalSettingsByStoreId(storeId, null);
    }

    /**
    * Get terminal settings
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings getTerminalSettingsByStoreId(String storeId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    /**
    * Update the terminal logo
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param model {@link String } The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T (required)
    * @param logo {@link Logo }  (required)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo updateTerminalLogo(String merchantId, String reference, String model, Logo logo) throws ApiException, IOException {
        return updateTerminalLogo(merchantId, reference, model,  logo, null);
    }

    /**
    * Update the terminal logo
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param logo {@link Logo }  (required)
    * @param model {@link String } Query: The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo updateTerminalLogo(String merchantId, String reference, String model, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (model != null) {
        queryParams.put("model", model);
        }

        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    /**
    * Update terminal settings
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param terminalSettings {@link TerminalSettings }  (required)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings updateTerminalSettings(String merchantId, String reference, TerminalSettings terminalSettings) throws ApiException, IOException {
        return updateTerminalSettings(merchantId, reference, terminalSettings, null);
    }

    /**
    * Update terminal settings
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param reference {@link String } The reference that identifies the store. (required)
    * @param terminalSettings {@link TerminalSettings }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings updateTerminalSettings(String merchantId, String reference, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);

        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    /**
    * Update the terminal logo
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param model {@link String } The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T. (required)
    * @param logo {@link Logo }  (required)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo updateTerminalLogoByStoreId(String storeId, String model, Logo logo) throws ApiException, IOException {
        return updateTerminalLogoByStoreId(storeId, model,  logo, null);
    }

    /**
    * Update the terminal logo
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param logo {@link Logo }  (required)
    * @param model {@link String } Query: The terminal model. Possible values: E355, VX675WIFIBT, VX680, VX690, VX700, VX820, M400, MX925, P400Plus, UX300, UX410, V200cPlus, V240mPlus, V400cPlus, V400m, e280, e285, e285p, S1E, S1EL, S1F2, S1L, S1U, S7T. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Logo }
    * @throws ApiException if fails to make API call
    */
    public Logo updateTerminalLogoByStoreId(String storeId, String model, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (model != null) {
        queryParams.put("model", model);
        }

        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    /**
    * Update terminal settings
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param terminalSettings {@link TerminalSettings }  (required)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings updateTerminalSettingsByStoreId(String storeId, TerminalSettings terminalSettings) throws ApiException, IOException {
        return updateTerminalSettingsByStoreId(storeId, terminalSettings, null);
    }

    /**
    * Update terminal settings
    *
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param terminalSettings {@link TerminalSettings }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TerminalSettings }
    * @throws ApiException if fails to make API call
    */
    public TerminalSettings updateTerminalSettingsByStoreId(String storeId, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);

        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }
}
