/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.legalentitymanagement.BusinessLine;
import com.adyen.model.legalentitymanagement.BusinessLineInfo;
import com.adyen.model.legalentitymanagement.BusinessLineInfoUpdate;
import com.adyen.model.legalentitymanagement.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BusinessLinesApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * Business lines constructor in {@link com.adyen.service.legalentitymanagement package}.
    * @param client {@link Client } (required)
    */
    public BusinessLinesApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    /**
    * Business lines constructor in {@link com.adyen.service.legalentitymanagement package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public BusinessLinesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Delete a business line
    *
    * @param id {@link String } The unique identifier of the business line to be deleted. (required)
    * @throws ApiException if fails to make API call
    */
    public void deleteBusinessLine(String id) throws ApiException, IOException {
        deleteBusinessLine(id, null);
    }

    /**
    * Delete a business line
    *
    * @param id {@link String } The unique identifier of the business line to be deleted. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @throws ApiException if fails to make API call
    */
    public void deleteBusinessLine(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/businessLines/{id}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    /**
    * Get a business line
    *
    * @param id {@link String } The unique identifier of the business line. (required)
    * @return {@link BusinessLine }
    * @throws ApiException if fails to make API call
    */
    public BusinessLine getBusinessLine(String id) throws ApiException, IOException {
        return getBusinessLine(id, null);
    }

    /**
    * Get a business line
    *
    * @param id {@link String } The unique identifier of the business line. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link BusinessLine }
    * @throws ApiException if fails to make API call
    */
    public BusinessLine getBusinessLine(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/businessLines/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return BusinessLine.fromJson(jsonResult);
    }

    /**
    * Update a business line
    *
    * @param id {@link String } The unique identifier of the business line. (required)
    * @param businessLineInfoUpdate {@link BusinessLineInfoUpdate }  (required)
    * @return {@link BusinessLine }
    * @throws ApiException if fails to make API call
    */
    public BusinessLine updateBusinessLine(String id, BusinessLineInfoUpdate businessLineInfoUpdate) throws ApiException, IOException {
        return updateBusinessLine(id, businessLineInfoUpdate, null);
    }

    /**
    * Update a business line
    *
    * @param id {@link String } The unique identifier of the business line. (required)
    * @param businessLineInfoUpdate {@link BusinessLineInfoUpdate }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link BusinessLine }
    * @throws ApiException if fails to make API call
    */
    public BusinessLine updateBusinessLine(String id, BusinessLineInfoUpdate businessLineInfoUpdate, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = businessLineInfoUpdate.toJson();
        Resource resource = new Resource(this, this.baseURL + "/businessLines/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return BusinessLine.fromJson(jsonResult);
    }

    /**
    * Create a business line
    *
    * @param businessLineInfo {@link BusinessLineInfo }  (required)
    * @return {@link BusinessLine }
    * @throws ApiException if fails to make API call
    */
    public BusinessLine createBusinessLine(BusinessLineInfo businessLineInfo) throws ApiException, IOException {
        return createBusinessLine(businessLineInfo, null);
    }

    /**
    * Create a business line
    *
    * @param businessLineInfo {@link BusinessLineInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link BusinessLine }
    * @throws ApiException if fails to make API call
    */
    public BusinessLine createBusinessLine(BusinessLineInfo businessLineInfo, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = businessLineInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/businessLines", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return BusinessLine.fromJson(jsonResult);
    }
}
