/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayaccount;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BankAccountDetail
 */
@JsonPropertyOrder({
  BankAccountDetail.JSON_PROPERTY_ACCOUNT_NUMBER,
  BankAccountDetail.JSON_PROPERTY_ACCOUNT_TYPE,
  BankAccountDetail.JSON_PROPERTY_BANK_ACCOUNT_NAME,
  BankAccountDetail.JSON_PROPERTY_BANK_ACCOUNT_REFERENCE,
  BankAccountDetail.JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D,
  BankAccountDetail.JSON_PROPERTY_BANK_BIC_SWIFT,
  BankAccountDetail.JSON_PROPERTY_BANK_CITY,
  BankAccountDetail.JSON_PROPERTY_BANK_CODE,
  BankAccountDetail.JSON_PROPERTY_BANK_NAME,
  BankAccountDetail.JSON_PROPERTY_BRANCH_CODE,
  BankAccountDetail.JSON_PROPERTY_CHECK_CODE,
  BankAccountDetail.JSON_PROPERTY_COUNTRY_CODE,
  BankAccountDetail.JSON_PROPERTY_CURRENCY_CODE,
  BankAccountDetail.JSON_PROPERTY_IBAN,
  BankAccountDetail.JSON_PROPERTY_OWNER_CITY,
  BankAccountDetail.JSON_PROPERTY_OWNER_COUNTRY_CODE,
  BankAccountDetail.JSON_PROPERTY_OWNER_DATE_OF_BIRTH,
  BankAccountDetail.JSON_PROPERTY_OWNER_HOUSE_NUMBER_OR_NAME,
  BankAccountDetail.JSON_PROPERTY_OWNER_NAME,
  BankAccountDetail.JSON_PROPERTY_OWNER_NATIONALITY,
  BankAccountDetail.JSON_PROPERTY_OWNER_POSTAL_CODE,
  BankAccountDetail.JSON_PROPERTY_OWNER_STATE,
  BankAccountDetail.JSON_PROPERTY_OWNER_STREET,
  BankAccountDetail.JSON_PROPERTY_PRIMARY_ACCOUNT,
  BankAccountDetail.JSON_PROPERTY_TAX_ID,
  BankAccountDetail.JSON_PROPERTY_URL_FOR_VERIFICATION
})

public class BankAccountDetail {
  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private String accountType;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_NAME = "bankAccountName";
  private String bankAccountName;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_REFERENCE = "bankAccountReference";
  private String bankAccountReference;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
  private String bankAccountUUID;

  public static final String JSON_PROPERTY_BANK_BIC_SWIFT = "bankBicSwift";
  private String bankBicSwift;

  public static final String JSON_PROPERTY_BANK_CITY = "bankCity";
  private String bankCity;

  public static final String JSON_PROPERTY_BANK_CODE = "bankCode";
  private String bankCode;

  public static final String JSON_PROPERTY_BANK_NAME = "bankName";
  private String bankName;

  public static final String JSON_PROPERTY_BRANCH_CODE = "branchCode";
  private String branchCode;

  public static final String JSON_PROPERTY_CHECK_CODE = "checkCode";
  private String checkCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_IBAN = "iban";
  private String iban;

  public static final String JSON_PROPERTY_OWNER_CITY = "ownerCity";
  private String ownerCity;

  public static final String JSON_PROPERTY_OWNER_COUNTRY_CODE = "ownerCountryCode";
  private String ownerCountryCode;

  public static final String JSON_PROPERTY_OWNER_DATE_OF_BIRTH = "ownerDateOfBirth";
  private String ownerDateOfBirth;

  public static final String JSON_PROPERTY_OWNER_HOUSE_NUMBER_OR_NAME = "ownerHouseNumberOrName";
  private String ownerHouseNumberOrName;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_OWNER_NATIONALITY = "ownerNationality";
  private String ownerNationality;

  public static final String JSON_PROPERTY_OWNER_POSTAL_CODE = "ownerPostalCode";
  private String ownerPostalCode;

  public static final String JSON_PROPERTY_OWNER_STATE = "ownerState";
  private String ownerState;

  public static final String JSON_PROPERTY_OWNER_STREET = "ownerStreet";
  private String ownerStreet;

  public static final String JSON_PROPERTY_PRIMARY_ACCOUNT = "primaryAccount";
  private Boolean primaryAccount;

  public static final String JSON_PROPERTY_TAX_ID = "taxId";
  private String taxId;

  public static final String JSON_PROPERTY_URL_FOR_VERIFICATION = "urlForVerification";
  private String urlForVerification;

  public BankAccountDetail() { 
  }

  public BankAccountDetail accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * The bank account number (without separators). &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return accountNumber
  **/
  @ApiModelProperty(value = "The bank account number (without separators). >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountNumber() {
    return accountNumber;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public BankAccountDetail accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * The type of bank account. Only applicable to bank accounts held in the USA. The permitted values are: &#x60;checking&#x60;, &#x60;savings&#x60;.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return accountType
  **/
  @ApiModelProperty(value = "The type of bank account. Only applicable to bank accounts held in the USA. The permitted values are: `checking`, `savings`.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountType() {
    return accountType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public BankAccountDetail bankAccountName(String bankAccountName) {
    this.bankAccountName = bankAccountName;
    return this;
  }

   /**
   * The name of the bank account.
   * @return bankAccountName
  **/
  @ApiModelProperty(value = "The name of the bank account.")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankAccountName() {
    return bankAccountName;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountName(String bankAccountName) {
    this.bankAccountName = bankAccountName;
  }


  public BankAccountDetail bankAccountReference(String bankAccountReference) {
    this.bankAccountReference = bankAccountReference;
    return this;
  }

   /**
   * Merchant reference to the bank account.
   * @return bankAccountReference
  **/
  @ApiModelProperty(value = "Merchant reference to the bank account.")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankAccountReference() {
    return bankAccountReference;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountReference(String bankAccountReference) {
    this.bankAccountReference = bankAccountReference;
  }


  public BankAccountDetail bankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
    return this;
  }

   /**
   * The unique identifier (UUID) of the Bank Account. &gt;If, during an account holder create or update request, this field is left blank (but other fields provided), a new Bank Account will be created with a procedurally-generated UUID.  &gt;If, during an account holder create request, a UUID is provided, the creation of the Bank Account will fail while the creation of the account holder will continue.  &gt;If, during an account holder update request, a UUID that is not correlated with an existing Bank Account is provided, the update of the account holder will fail.  &gt;If, during an account holder update request, a UUID that is correlated with an existing Bank Account is provided, the existing Bank Account will be updated. 
   * @return bankAccountUUID
  **/
  @ApiModelProperty(value = "The unique identifier (UUID) of the Bank Account. >If, during an account holder create or update request, this field is left blank (but other fields provided), a new Bank Account will be created with a procedurally-generated UUID.  >If, during an account holder create request, a UUID is provided, the creation of the Bank Account will fail while the creation of the account holder will continue.  >If, during an account holder update request, a UUID that is not correlated with an existing Bank Account is provided, the update of the account holder will fail.  >If, during an account holder update request, a UUID that is correlated with an existing Bank Account is provided, the existing Bank Account will be updated. ")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankAccountUUID() {
    return bankAccountUUID;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
  }


  public BankAccountDetail bankBicSwift(String bankBicSwift) {
    this.bankBicSwift = bankBicSwift;
    return this;
  }

   /**
   * The bank identifier code. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return bankBicSwift
  **/
  @ApiModelProperty(value = "The bank identifier code. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_BANK_BIC_SWIFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankBicSwift() {
    return bankBicSwift;
  }


  @JsonProperty(JSON_PROPERTY_BANK_BIC_SWIFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankBicSwift(String bankBicSwift) {
    this.bankBicSwift = bankBicSwift;
  }


  public BankAccountDetail bankCity(String bankCity) {
    this.bankCity = bankCity;
    return this;
  }

   /**
   * The city in which the bank branch is located.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return bankCity
  **/
  @ApiModelProperty(value = "The city in which the bank branch is located.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_BANK_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankCity() {
    return bankCity;
  }


  @JsonProperty(JSON_PROPERTY_BANK_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankCity(String bankCity) {
    this.bankCity = bankCity;
  }


  public BankAccountDetail bankCode(String bankCode) {
    this.bankCode = bankCode;
    return this;
  }

   /**
   * The bank code of the banking institution with which the bank account is registered.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return bankCode
  **/
  @ApiModelProperty(value = "The bank code of the banking institution with which the bank account is registered.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_BANK_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankCode() {
    return bankCode;
  }


  @JsonProperty(JSON_PROPERTY_BANK_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankCode(String bankCode) {
    this.bankCode = bankCode;
  }


  public BankAccountDetail bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

   /**
   * The name of the banking institution with which the bank account is held.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return bankName
  **/
  @ApiModelProperty(value = "The name of the banking institution with which the bank account is held.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankName() {
    return bankName;
  }


  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankName(String bankName) {
    this.bankName = bankName;
  }


  public BankAccountDetail branchCode(String branchCode) {
    this.branchCode = branchCode;
    return this;
  }

   /**
   * The branch code of the branch under which the bank account is registered. The value to be specified in this parameter depends on the country of the bank account: * United States - Routing number * United Kingdom - Sort code * Germany - Bankleitzahl &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return branchCode
  **/
  @ApiModelProperty(value = "The branch code of the branch under which the bank account is registered. The value to be specified in this parameter depends on the country of the bank account: * United States - Routing number * United Kingdom - Sort code * Germany - Bankleitzahl >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_BRANCH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBranchCode() {
    return branchCode;
  }


  @JsonProperty(JSON_PROPERTY_BRANCH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBranchCode(String branchCode) {
    this.branchCode = branchCode;
  }


  public BankAccountDetail checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * The check code of the bank account.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return checkCode
  **/
  @ApiModelProperty(value = "The check code of the bank account.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_CHECK_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCheckCode() {
    return checkCode;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }


  public BankAccountDetail countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The two-letter country code in which the bank account is registered. &gt;The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. &#39;NL&#39;).  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return countryCode
  **/
  @ApiModelProperty(value = "The two-letter country code in which the bank account is registered. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public BankAccountDetail currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * The currency in which the bank account deals. &gt;The permitted currency codes are defined in ISO-4217 (e.g. &#39;EUR&#39;). 
   * @return currencyCode
  **/
  @ApiModelProperty(value = "The currency in which the bank account deals. >The permitted currency codes are defined in ISO-4217 (e.g. 'EUR'). ")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public BankAccountDetail iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * The international bank account number. &gt;The IBAN standard is defined in ISO-13616.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return iban
  **/
  @ApiModelProperty(value = "The international bank account number. >The IBAN standard is defined in ISO-13616.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIban() {
    return iban;
  }


  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIban(String iban) {
    this.iban = iban;
  }


  public BankAccountDetail ownerCity(String ownerCity) {
    this.ownerCity = ownerCity;
    return this;
  }

   /**
   * The city of residence of the bank account owner. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerCity
  **/
  @ApiModelProperty(value = "The city of residence of the bank account owner. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerCity() {
    return ownerCity;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerCity(String ownerCity) {
    this.ownerCity = ownerCity;
  }


  public BankAccountDetail ownerCountryCode(String ownerCountryCode) {
    this.ownerCountryCode = ownerCountryCode;
    return this;
  }

   /**
   * The country code of the country of residence of the bank account owner. &gt;The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. &#39;NL&#39;).  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerCountryCode
  **/
  @ApiModelProperty(value = "The country code of the country of residence of the bank account owner. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerCountryCode() {
    return ownerCountryCode;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerCountryCode(String ownerCountryCode) {
    this.ownerCountryCode = ownerCountryCode;
  }


  public BankAccountDetail ownerDateOfBirth(String ownerDateOfBirth) {
    this.ownerDateOfBirth = ownerDateOfBirth;
    return this;
  }

   /**
   * The date of birth of the bank account owner. The date should be in ISO-8601 format yyyy-mm-dd (e.g. 2000-01-31).
   * @return ownerDateOfBirth
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The date of birth of the bank account owner. The date should be in ISO-8601 format yyyy-mm-dd (e.g. 2000-01-31).")
  @JsonProperty(JSON_PROPERTY_OWNER_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerDateOfBirth() {
    return ownerDateOfBirth;
  }


  @Deprecated
  @JsonProperty(JSON_PROPERTY_OWNER_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerDateOfBirth(String ownerDateOfBirth) {
    this.ownerDateOfBirth = ownerDateOfBirth;
  }


  public BankAccountDetail ownerHouseNumberOrName(String ownerHouseNumberOrName) {
    this.ownerHouseNumberOrName = ownerHouseNumberOrName;
    return this;
  }

   /**
   * The house name or number of the residence of the bank account owner. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerHouseNumberOrName
  **/
  @ApiModelProperty(value = "The house name or number of the residence of the bank account owner. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_HOUSE_NUMBER_OR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerHouseNumberOrName() {
    return ownerHouseNumberOrName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_HOUSE_NUMBER_OR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerHouseNumberOrName(String ownerHouseNumberOrName) {
    this.ownerHouseNumberOrName = ownerHouseNumberOrName;
  }


  public BankAccountDetail ownerName(String ownerName) {
    this.ownerName = ownerName;
    return this;
  }

   /**
   * The name of the bank account owner. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerName
  **/
  @ApiModelProperty(value = "The name of the bank account owner. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public BankAccountDetail ownerNationality(String ownerNationality) {
    this.ownerNationality = ownerNationality;
    return this;
  }

   /**
   * The country code of the country of nationality of the bank account owner. &gt;The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. &#39;NL&#39;).  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerNationality
  **/
  @ApiModelProperty(value = "The country code of the country of nationality of the bank account owner. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerNationality() {
    return ownerNationality;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerNationality(String ownerNationality) {
    this.ownerNationality = ownerNationality;
  }


  public BankAccountDetail ownerPostalCode(String ownerPostalCode) {
    this.ownerPostalCode = ownerPostalCode;
    return this;
  }

   /**
   * The postal code of the residence of the bank account owner. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerPostalCode
  **/
  @ApiModelProperty(value = "The postal code of the residence of the bank account owner. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerPostalCode() {
    return ownerPostalCode;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerPostalCode(String ownerPostalCode) {
    this.ownerPostalCode = ownerPostalCode;
  }


  public BankAccountDetail ownerState(String ownerState) {
    this.ownerState = ownerState;
    return this;
  }

   /**
   * The state of residence of the bank account owner. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerState
  **/
  @ApiModelProperty(value = "The state of residence of the bank account owner. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerState() {
    return ownerState;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerState(String ownerState) {
    this.ownerState = ownerState;
  }


  public BankAccountDetail ownerStreet(String ownerStreet) {
    this.ownerStreet = ownerStreet;
    return this;
  }

   /**
   * The street name of the residence of the bank account owner. &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return ownerStreet
  **/
  @ApiModelProperty(value = "The street name of the residence of the bank account owner. >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_OWNER_STREET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerStreet() {
    return ownerStreet;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_STREET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerStreet(String ownerStreet) {
    this.ownerStreet = ownerStreet;
  }


  public BankAccountDetail primaryAccount(Boolean primaryAccount) {
    this.primaryAccount = primaryAccount;
    return this;
  }

   /**
   * If set to true, the bank account is a primary account.
   * @return primaryAccount
  **/
  @ApiModelProperty(value = "If set to true, the bank account is a primary account.")
  @JsonProperty(JSON_PROPERTY_PRIMARY_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPrimaryAccount() {
    return primaryAccount;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimaryAccount(Boolean primaryAccount) {
    this.primaryAccount = primaryAccount;
  }


  public BankAccountDetail taxId(String taxId) {
    this.taxId = taxId;
    return this;
  }

   /**
   * The tax ID number.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return taxId
  **/
  @ApiModelProperty(value = "The tax ID number.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTaxId() {
    return taxId;
  }


  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxId(String taxId) {
    this.taxId = taxId;
  }


  public BankAccountDetail urlForVerification(String urlForVerification) {
    this.urlForVerification = urlForVerification;
    return this;
  }

   /**
   * The URL to be used for bank account verification. This may be generated on bank account creation.  &gt;Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.
   * @return urlForVerification
  **/
  @ApiModelProperty(value = "The URL to be used for bank account verification. This may be generated on bank account creation.  >Refer to [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information) for details on field requirements.")
  @JsonProperty(JSON_PROPERTY_URL_FOR_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlForVerification() {
    return urlForVerification;
  }


  @JsonProperty(JSON_PROPERTY_URL_FOR_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlForVerification(String urlForVerification) {
    this.urlForVerification = urlForVerification;
  }


  /**
   * Return true if this BankAccountDetail object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAccountDetail bankAccountDetail = (BankAccountDetail) o;
    return Objects.equals(this.accountNumber, bankAccountDetail.accountNumber) &&
        Objects.equals(this.accountType, bankAccountDetail.accountType) &&
        Objects.equals(this.bankAccountName, bankAccountDetail.bankAccountName) &&
        Objects.equals(this.bankAccountReference, bankAccountDetail.bankAccountReference) &&
        Objects.equals(this.bankAccountUUID, bankAccountDetail.bankAccountUUID) &&
        Objects.equals(this.bankBicSwift, bankAccountDetail.bankBicSwift) &&
        Objects.equals(this.bankCity, bankAccountDetail.bankCity) &&
        Objects.equals(this.bankCode, bankAccountDetail.bankCode) &&
        Objects.equals(this.bankName, bankAccountDetail.bankName) &&
        Objects.equals(this.branchCode, bankAccountDetail.branchCode) &&
        Objects.equals(this.checkCode, bankAccountDetail.checkCode) &&
        Objects.equals(this.countryCode, bankAccountDetail.countryCode) &&
        Objects.equals(this.currencyCode, bankAccountDetail.currencyCode) &&
        Objects.equals(this.iban, bankAccountDetail.iban) &&
        Objects.equals(this.ownerCity, bankAccountDetail.ownerCity) &&
        Objects.equals(this.ownerCountryCode, bankAccountDetail.ownerCountryCode) &&
        Objects.equals(this.ownerDateOfBirth, bankAccountDetail.ownerDateOfBirth) &&
        Objects.equals(this.ownerHouseNumberOrName, bankAccountDetail.ownerHouseNumberOrName) &&
        Objects.equals(this.ownerName, bankAccountDetail.ownerName) &&
        Objects.equals(this.ownerNationality, bankAccountDetail.ownerNationality) &&
        Objects.equals(this.ownerPostalCode, bankAccountDetail.ownerPostalCode) &&
        Objects.equals(this.ownerState, bankAccountDetail.ownerState) &&
        Objects.equals(this.ownerStreet, bankAccountDetail.ownerStreet) &&
        Objects.equals(this.primaryAccount, bankAccountDetail.primaryAccount) &&
        Objects.equals(this.taxId, bankAccountDetail.taxId) &&
        Objects.equals(this.urlForVerification, bankAccountDetail.urlForVerification);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNumber, accountType, bankAccountName, bankAccountReference, bankAccountUUID, bankBicSwift, bankCity, bankCode, bankName, branchCode, checkCode, countryCode, currencyCode, iban, ownerCity, ownerCountryCode, ownerDateOfBirth, ownerHouseNumberOrName, ownerName, ownerNationality, ownerPostalCode, ownerState, ownerStreet, primaryAccount, taxId, urlForVerification);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAccountDetail {\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    bankAccountName: ").append(toIndentedString(bankAccountName)).append("\n");
    sb.append("    bankAccountReference: ").append(toIndentedString(bankAccountReference)).append("\n");
    sb.append("    bankAccountUUID: ").append(toIndentedString(bankAccountUUID)).append("\n");
    sb.append("    bankBicSwift: ").append(toIndentedString(bankBicSwift)).append("\n");
    sb.append("    bankCity: ").append(toIndentedString(bankCity)).append("\n");
    sb.append("    bankCode: ").append(toIndentedString(bankCode)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    branchCode: ").append(toIndentedString(branchCode)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    ownerCity: ").append(toIndentedString(ownerCity)).append("\n");
    sb.append("    ownerCountryCode: ").append(toIndentedString(ownerCountryCode)).append("\n");
    sb.append("    ownerDateOfBirth: ").append(toIndentedString(ownerDateOfBirth)).append("\n");
    sb.append("    ownerHouseNumberOrName: ").append(toIndentedString(ownerHouseNumberOrName)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    ownerNationality: ").append(toIndentedString(ownerNationality)).append("\n");
    sb.append("    ownerPostalCode: ").append(toIndentedString(ownerPostalCode)).append("\n");
    sb.append("    ownerState: ").append(toIndentedString(ownerState)).append("\n");
    sb.append("    ownerStreet: ").append(toIndentedString(ownerStreet)).append("\n");
    sb.append("    primaryAccount: ").append(toIndentedString(primaryAccount)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("    urlForVerification: ").append(toIndentedString(urlForVerification)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BankAccountDetail given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BankAccountDetail
   * @throws JsonProcessingException if the JSON string is invalid with respect to BankAccountDetail
   */
  public static BankAccountDetail fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BankAccountDetail.class);
  }
/**
  * Convert an instance of BankAccountDetail to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

