/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayconfiguration;

import com.adyen.model.marketpayconfiguration.ErrorFieldType;
import com.adyen.model.marketpayconfiguration.ExchangeMessage;
import com.adyen.model.marketpayconfiguration.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"errorMessages", "eventTypes", "exchangeMessages", "invalidFields", "notificationId", "okMessages", "pspReference", "resultCode"})
public class TestNotificationConfigurationResponse {
    public static final String JSON_PROPERTY_ERROR_MESSAGES = "errorMessages";
    private List<String> errorMessages = null;
    public static final String JSON_PROPERTY_EVENT_TYPES = "eventTypes";
    private List<EventTypesEnum> eventTypes = null;
    public static final String JSON_PROPERTY_EXCHANGE_MESSAGES = "exchangeMessages";
    private List<ExchangeMessage> exchangeMessages = null;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_NOTIFICATION_ID = "notificationId";
    private Long notificationId;
    public static final String JSON_PROPERTY_OK_MESSAGES = "okMessages";
    private List<String> okMessages = null;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private String resultCode;

    public TestNotificationConfigurationResponse errorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
        return this;
    }

    public TestNotificationConfigurationResponse addErrorMessagesItem(String errorMessagesItem) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(errorMessagesItem);
        return this;
    }

    @ApiModelProperty(value="Any error messages encountered.")
    @JsonProperty(value="errorMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    @JsonProperty(value="errorMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public TestNotificationConfigurationResponse eventTypes(List<EventTypesEnum> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public TestNotificationConfigurationResponse addEventTypesItem(EventTypesEnum eventTypesItem) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<EventTypesEnum>();
        }
        this.eventTypes.add(eventTypesItem);
        return this;
    }

    @ApiModelProperty(value="The event types that were tested. >Permitted values: `ACCOUNT_HOLDER_CREATED`, `ACCOUNT_CREATED`, `ACCOUNT_UPDATED`, `ACCOUNT_HOLDER_UPDATED`, `ACCOUNT_HOLDER_STATUS_CHANGE`, `ACCOUNT_HOLDER_STORE_STATUS_CHANGE` `ACCOUNT_HOLDER_VERIFICATION`, `ACCOUNT_HOLDER_LIMIT_REACHED`, `ACCOUNT_HOLDER_PAYOUT`, `PAYMENT_FAILURE`, `SCHEDULED_REFUNDS`, `REPORT_AVAILABLE`, `TRANSFER_FUNDS`, `BENEFICIARY_SETUP`, `COMPENSATE_NEGATIVE_BALANCE`.")
    @JsonProperty(value="eventTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventTypesEnum> getEventTypes() {
        return this.eventTypes;
    }

    @JsonProperty(value="eventTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTypes(List<EventTypesEnum> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public TestNotificationConfigurationResponse exchangeMessages(List<ExchangeMessage> exchangeMessages) {
        this.exchangeMessages = exchangeMessages;
        return this;
    }

    public TestNotificationConfigurationResponse addExchangeMessagesItem(ExchangeMessage exchangeMessagesItem) {
        if (this.exchangeMessages == null) {
            this.exchangeMessages = new ArrayList<ExchangeMessage>();
        }
        this.exchangeMessages.add(exchangeMessagesItem);
        return this;
    }

    @ApiModelProperty(value="The notification message and related response messages.")
    @JsonProperty(value="exchangeMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExchangeMessage> getExchangeMessages() {
        return this.exchangeMessages;
    }

    @JsonProperty(value="exchangeMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeMessages(List<ExchangeMessage> exchangeMessages) {
        this.exchangeMessages = exchangeMessages;
    }

    public TestNotificationConfigurationResponse invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public TestNotificationConfigurationResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Contains field validation errors that would prevent requests from being processed.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public TestNotificationConfigurationResponse notificationId(Long notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the notification subscription configuration.")
    @JsonProperty(value="notificationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNotificationId() {
        return this.notificationId;
    }

    @JsonProperty(value="notificationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public TestNotificationConfigurationResponse okMessages(List<String> okMessages) {
        this.okMessages = okMessages;
        return this;
    }

    public TestNotificationConfigurationResponse addOkMessagesItem(String okMessagesItem) {
        if (this.okMessages == null) {
            this.okMessages = new ArrayList<String>();
        }
        this.okMessages.add(okMessagesItem);
        return this;
    }

    @ApiModelProperty(value="A list of messages describing the testing steps.")
    @JsonProperty(value="okMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOkMessages() {
        return this.okMessages;
    }

    @JsonProperty(value="okMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOkMessages(List<String> okMessages) {
        this.okMessages = okMessages;
    }

    public TestNotificationConfigurationResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of a request. Can be used to uniquely identify the request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public TestNotificationConfigurationResponse resultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result code.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestNotificationConfigurationResponse testNotificationConfigurationResponse = (TestNotificationConfigurationResponse)o;
        return Objects.equals(this.errorMessages, testNotificationConfigurationResponse.errorMessages) && Objects.equals(this.eventTypes, testNotificationConfigurationResponse.eventTypes) && Objects.equals(this.exchangeMessages, testNotificationConfigurationResponse.exchangeMessages) && Objects.equals(this.invalidFields, testNotificationConfigurationResponse.invalidFields) && Objects.equals(this.notificationId, testNotificationConfigurationResponse.notificationId) && Objects.equals(this.okMessages, testNotificationConfigurationResponse.okMessages) && Objects.equals(this.pspReference, testNotificationConfigurationResponse.pspReference) && Objects.equals(this.resultCode, testNotificationConfigurationResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessages, this.eventTypes, this.exchangeMessages, this.invalidFields, this.notificationId, this.okMessages, this.pspReference, this.resultCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestNotificationConfigurationResponse {\n");
        sb.append("    errorMessages: ").append(this.toIndentedString(this.errorMessages)).append("\n");
        sb.append("    eventTypes: ").append(this.toIndentedString(this.eventTypes)).append("\n");
        sb.append("    exchangeMessages: ").append(this.toIndentedString(this.exchangeMessages)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    notificationId: ").append(this.toIndentedString(this.notificationId)).append("\n");
        sb.append("    okMessages: ").append(this.toIndentedString(this.okMessages)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString(this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TestNotificationConfigurationResponse fromJson(String jsonString) throws JsonProcessingException {
        return (TestNotificationConfigurationResponse)JSON.getMapper().readValue(jsonString, TestNotificationConfigurationResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EventTypesEnum {
        ACCOUNT_CLOSED("ACCOUNT_CLOSED"),
        ACCOUNT_CREATED("ACCOUNT_CREATED"),
        ACCOUNT_FUNDS_BELOW_THRESHOLD("ACCOUNT_FUNDS_BELOW_THRESHOLD"),
        ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
        ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
        ACCOUNT_HOLDER_MIGRATED("ACCOUNT_HOLDER_MIGRATED"),
        ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
        ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
        ACCOUNT_HOLDER_STORE_STATUS_CHANGE("ACCOUNT_HOLDER_STORE_STATUS_CHANGE"),
        ACCOUNT_HOLDER_UPCOMING_DEADLINE("ACCOUNT_HOLDER_UPCOMING_DEADLINE"),
        ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
        ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
        ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
        BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
        COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
        DIRECT_DEBIT_INITIATED("DIRECT_DEBIT_INITIATED"),
        FUNDS_MIGRATED("FUNDS_MIGRATED"),
        PAYMENT_FAILURE("PAYMENT_FAILURE"),
        PENDING_CREDIT("PENDING_CREDIT"),
        REFUND_FUNDS_TRANSFER("REFUND_FUNDS_TRANSFER"),
        REPORT_AVAILABLE("REPORT_AVAILABLE"),
        SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
        SCORE_SIGNAL_TRIGGERED("SCORE_SIGNAL_TRIGGERED"),
        TRANSFER_FUNDS("TRANSFER_FUNDS"),
        TRANSFER_NOT_PAIDOUT_TRANSFERS("TRANSFER_NOT_PAIDOUT_TRANSFERS");

        private String value;

        private EventTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypesEnum fromValue(String value) {
            for (EventTypesEnum b : EventTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

