/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.TerminalAssignment;
import com.adyen.model.management.TerminalConnectivity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"assignment", "connectivity", "firmwareVersion", "id", "lastActivityAt", "lastTransactionAt", "model", "serialNumber"})
public class Terminal {
    public static final String JSON_PROPERTY_ASSIGNMENT = "assignment";
    private TerminalAssignment assignment;
    public static final String JSON_PROPERTY_CONNECTIVITY = "connectivity";
    private TerminalConnectivity connectivity;
    public static final String JSON_PROPERTY_FIRMWARE_VERSION = "firmwareVersion";
    private String firmwareVersion;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_ACTIVITY_AT = "lastActivityAt";
    private OffsetDateTime lastActivityAt;
    public static final String JSON_PROPERTY_LAST_TRANSACTION_AT = "lastTransactionAt";
    private OffsetDateTime lastTransactionAt;
    public static final String JSON_PROPERTY_MODEL = "model";
    private String model;
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;

    public Terminal assignment(TerminalAssignment assignment) {
        this.assignment = assignment;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="assignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TerminalAssignment getAssignment() {
        return this.assignment;
    }

    @JsonProperty(value="assignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignment(TerminalAssignment assignment) {
        this.assignment = assignment;
    }

    public Terminal connectivity(TerminalConnectivity connectivity) {
        this.connectivity = connectivity;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="connectivity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TerminalConnectivity getConnectivity() {
        return this.connectivity;
    }

    @JsonProperty(value="connectivity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectivity(TerminalConnectivity connectivity) {
        this.connectivity = connectivity;
    }

    public Terminal firmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    @ApiModelProperty(value="The software release currently in use on the terminal.")
    @JsonProperty(value="firmwareVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @JsonProperty(value="firmwareVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public Terminal id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the terminal.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Terminal lastActivityAt(OffsetDateTime lastActivityAt) {
        this.lastActivityAt = lastActivityAt;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.")
    @JsonProperty(value="lastActivityAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastActivityAt() {
        return this.lastActivityAt;
    }

    @JsonProperty(value="lastActivityAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastActivityAt(OffsetDateTime lastActivityAt) {
        this.lastActivityAt = lastActivityAt;
    }

    public Terminal lastTransactionAt(OffsetDateTime lastTransactionAt) {
        this.lastTransactionAt = lastTransactionAt;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.")
    @JsonProperty(value="lastTransactionAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastTransactionAt() {
        return this.lastTransactionAt;
    }

    @JsonProperty(value="lastTransactionAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastTransactionAt(OffsetDateTime lastTransactionAt) {
        this.lastTransactionAt = lastTransactionAt;
    }

    public Terminal model(String model) {
        this.model = model;
        return this;
    }

    @ApiModelProperty(value="The model name of the terminal.")
    @JsonProperty(value="model")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="model")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModel(String model) {
        this.model = model;
    }

    public Terminal serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(value="The serial number of the terminal.")
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Terminal terminal = (Terminal)o;
        return Objects.equals(this.assignment, terminal.assignment) && Objects.equals(this.connectivity, terminal.connectivity) && Objects.equals(this.firmwareVersion, terminal.firmwareVersion) && Objects.equals(this.id, terminal.id) && Objects.equals(this.lastActivityAt, terminal.lastActivityAt) && Objects.equals(this.lastTransactionAt, terminal.lastTransactionAt) && Objects.equals(this.model, terminal.model) && Objects.equals(this.serialNumber, terminal.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.assignment, this.connectivity, this.firmwareVersion, this.id, this.lastActivityAt, this.lastTransactionAt, this.model, this.serialNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Terminal {\n");
        sb.append("    assignment: ").append(this.toIndentedString(this.assignment)).append("\n");
        sb.append("    connectivity: ").append(this.toIndentedString(this.connectivity)).append("\n");
        sb.append("    firmwareVersion: ").append(this.toIndentedString(this.firmwareVersion)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastActivityAt: ").append(this.toIndentedString(this.lastActivityAt)).append("\n");
        sb.append("    lastTransactionAt: ").append(this.toIndentedString(this.lastTransactionAt)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Terminal fromJson(String jsonString) throws JsonProcessingException {
        return (Terminal)JSON.getMapper().readValue(jsonString, Terminal.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

