/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acceptHeader", "colorDepth", "javaEnabled", "javaScriptEnabled", "language", "screenHeight", "screenWidth", "timeZoneOffset", "userAgent"})
public class BrowserInfo {
    public static final String JSON_PROPERTY_ACCEPT_HEADER = "acceptHeader";
    private String acceptHeader;
    public static final String JSON_PROPERTY_COLOR_DEPTH = "colorDepth";
    private Integer colorDepth;
    public static final String JSON_PROPERTY_JAVA_ENABLED = "javaEnabled";
    private Boolean javaEnabled;
    public static final String JSON_PROPERTY_JAVA_SCRIPT_ENABLED = "javaScriptEnabled";
    private Boolean javaScriptEnabled = true;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_SCREEN_HEIGHT = "screenHeight";
    private Integer screenHeight;
    public static final String JSON_PROPERTY_SCREEN_WIDTH = "screenWidth";
    private Integer screenWidth;
    public static final String JSON_PROPERTY_TIME_ZONE_OFFSET = "timeZoneOffset";
    private Integer timeZoneOffset;
    public static final String JSON_PROPERTY_USER_AGENT = "userAgent";
    private String userAgent;

    public BrowserInfo acceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
        return this;
    }

    @ApiModelProperty(required=true, value="The accept header value of the shopper's browser.")
    @JsonProperty(value="acceptHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    @JsonProperty(value="acceptHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public BrowserInfo colorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
        return this;
    }

    @ApiModelProperty(required=true, value="The color depth of the shopper's browser in bits per pixel. This should be obtained by using the browser's `screen.colorDepth` property. Accepted values: 1, 4, 8, 15, 16, 24, 30, 32 or 48 bit color depth.")
    @JsonProperty(value="colorDepth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getColorDepth() {
        return this.colorDepth;
    }

    @JsonProperty(value="colorDepth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
    }

    public BrowserInfo javaEnabled(Boolean javaEnabled) {
        this.javaEnabled = javaEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Boolean value indicating if the shopper's browser is able to execute Java.")
    @JsonProperty(value="javaEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getJavaEnabled() {
        return this.javaEnabled;
    }

    @JsonProperty(value="javaEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJavaEnabled(Boolean javaEnabled) {
        this.javaEnabled = javaEnabled;
    }

    public BrowserInfo javaScriptEnabled(Boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
        return this;
    }

    @ApiModelProperty(value="Boolean value indicating if the shopper's browser is able to execute JavaScript. A default 'true' value is assumed if the field is not present.")
    @JsonProperty(value="javaScriptEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getJavaScriptEnabled() {
        return this.javaScriptEnabled;
    }

    @JsonProperty(value="javaScriptEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJavaScriptEnabled(Boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
    }

    public BrowserInfo language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(required=true, value="The `navigator.language` value of the shopper's browser (as defined in IETF BCP 47).")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public BrowserInfo screenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The total height of the shopper's device screen in pixels.")
    @JsonProperty(value="screenHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScreenHeight() {
        return this.screenHeight;
    }

    @JsonProperty(value="screenHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
    }

    public BrowserInfo screenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="The total width of the shopper's device screen in pixels.")
    @JsonProperty(value="screenWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScreenWidth() {
        return this.screenWidth;
    }

    @JsonProperty(value="screenWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
    }

    public BrowserInfo timeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
        return this;
    }

    @ApiModelProperty(required=true, value="Time difference between UTC time and the shopper's browser local time, in minutes.")
    @JsonProperty(value="timeZoneOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    @JsonProperty(value="timeZoneOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public BrowserInfo userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(required=true, value="The user agent value of the shopper's browser.")
    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowserInfo browserInfo = (BrowserInfo)o;
        return Objects.equals(this.acceptHeader, browserInfo.acceptHeader) && Objects.equals(this.colorDepth, browserInfo.colorDepth) && Objects.equals(this.javaEnabled, browserInfo.javaEnabled) && Objects.equals(this.javaScriptEnabled, browserInfo.javaScriptEnabled) && Objects.equals(this.language, browserInfo.language) && Objects.equals(this.screenHeight, browserInfo.screenHeight) && Objects.equals(this.screenWidth, browserInfo.screenWidth) && Objects.equals(this.timeZoneOffset, browserInfo.timeZoneOffset) && Objects.equals(this.userAgent, browserInfo.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.acceptHeader, this.colorDepth, this.javaEnabled, this.javaScriptEnabled, this.language, this.screenHeight, this.screenWidth, this.timeZoneOffset, this.userAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowserInfo {\n");
        sb.append("    acceptHeader: ").append(this.toIndentedString(this.acceptHeader)).append("\n");
        sb.append("    colorDepth: ").append(this.toIndentedString(this.colorDepth)).append("\n");
        sb.append("    javaEnabled: ").append(this.toIndentedString(this.javaEnabled)).append("\n");
        sb.append("    javaScriptEnabled: ").append(this.toIndentedString(this.javaScriptEnabled)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    screenHeight: ").append(this.toIndentedString(this.screenHeight)).append("\n");
        sb.append("    screenWidth: ").append(this.toIndentedString(this.screenWidth)).append("\n");
        sb.append("    timeZoneOffset: ").append(this.toIndentedString(this.timeZoneOffset)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BrowserInfo fromJson(String jsonString) throws JsonProcessingException {
        return (BrowserInfo)JSON.getMapper().readValue(jsonString, BrowserInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

