/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.disputes;

import com.adyen.model.disputes.DisputeServiceResult;
import com.adyen.model.disputes.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;

@JsonPropertyOrder(value={"content", "contentType", "disputeServiceResult"})
public class DownloadDefenseDocumentResponse {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private byte[] content;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private String contentType;
    public static final String JSON_PROPERTY_DISPUTE_SERVICE_RESULT = "disputeServiceResult";
    private DisputeServiceResult disputeServiceResult;

    public DownloadDefenseDocumentResponse content(byte[] content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="The content of the defense document in Base64 binary format. Must be encoded in the format that is specified in the `contentType` field.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(byte[] content) {
        this.content = content;
    }

    public DownloadDefenseDocumentResponse contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="The content type of the dispute defense document.  Possible values:   * **image/jpg**  * **image/jpeg**  * **image/tiff**  * **application/pdf**")
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public DownloadDefenseDocumentResponse disputeServiceResult(DisputeServiceResult disputeServiceResult) {
        this.disputeServiceResult = disputeServiceResult;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="disputeServiceResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisputeServiceResult getDisputeServiceResult() {
        return this.disputeServiceResult;
    }

    @JsonProperty(value="disputeServiceResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisputeServiceResult(DisputeServiceResult disputeServiceResult) {
        this.disputeServiceResult = disputeServiceResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadDefenseDocumentResponse downloadDefenseDocumentResponse = (DownloadDefenseDocumentResponse)o;
        return Arrays.equals(this.content, downloadDefenseDocumentResponse.content) && Objects.equals(this.contentType, downloadDefenseDocumentResponse.contentType) && Objects.equals(this.disputeServiceResult, downloadDefenseDocumentResponse.disputeServiceResult);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.content), this.contentType, this.disputeServiceResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownloadDefenseDocumentResponse {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    disputeServiceResult: ").append(this.toIndentedString(this.disputeServiceResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DownloadDefenseDocumentResponse fromJson(String jsonString) throws JsonProcessingException {
        return (DownloadDefenseDocumentResponse)JSON.getMapper().readValue(jsonString, DownloadDefenseDocumentResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

