/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.Logo;
import com.adyen.model.management.TerminalSettings;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalSettingsTerminalLevelApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public TerminalSettingsTerminalLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v1");
    }

    public TerminalSettingsTerminalLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public Logo getTerminalLogo(String terminalId) throws ApiException, IOException {
        return this.getTerminalLogo(terminalId, null);
    }

    public Logo getTerminalLogo(String terminalId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (terminalId == null) {
            throw new IllegalArgumentException("Please provide the terminalId path parameter");
        }
        pathParams.put("terminalId", terminalId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/terminals/{terminalId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettings(String terminalId) throws ApiException, IOException {
        return this.getTerminalSettings(terminalId, null);
    }

    public TerminalSettings getTerminalSettings(String terminalId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (terminalId == null) {
            throw new IllegalArgumentException("Please provide the terminalId path parameter");
        }
        pathParams.put("terminalId", terminalId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/terminals/{terminalId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo updateLogo(String terminalId, Logo logo) throws ApiException, IOException {
        return this.updateLogo(terminalId, logo, null);
    }

    public Logo updateLogo(String terminalId, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (terminalId == null) {
            throw new IllegalArgumentException("Please provide the terminalId path parameter");
        }
        pathParams.put("terminalId", terminalId);
        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/terminals/{terminalId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettings(String terminalId, TerminalSettings terminalSettings) throws ApiException, IOException {
        return this.updateTerminalSettings(terminalId, terminalSettings, null);
    }

    public TerminalSettings updateTerminalSettings(String terminalId, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (terminalId == null) {
            throw new IllegalArgumentException("Please provide the terminalId path parameter");
        }
        pathParams.put("terminalId", terminalId);
        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/terminals/{terminalId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }
}

