/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"direction", "reference", "type"})
public class TransferOperation {
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private String direction;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public TransferOperation direction(String direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="The direction of the money movement.")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(String direction) {
        this.direction = direction;
    }

    public TransferOperation reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The reference returned when the amend was initiated.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransferOperation type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of amend for the transfer.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOperation transferOperation = (TransferOperation)o;
        return Objects.equals(this.direction, transferOperation.direction) && Objects.equals(this.reference, transferOperation.reference) && Objects.equals(this.type, transferOperation.type);
    }

    public int hashCode() {
        return Objects.hash(this.direction, this.reference, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOperation {\n");
        sb.append("    direction: ").append(this.toIndentedString(this.direction)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferOperation fromJson(String jsonString) throws JsonProcessingException {
        return (TransferOperation)JSON.getMapper().readValue(jsonString, TransferOperation.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

