/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"contract", "merchantAccount", "recurringDetailReference", "shopperReference"})
public class DisableRequest {
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    private String contract;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public DisableRequest contract(String contract) {
        this.contract = contract;
        return this;
    }

    @ApiModelProperty(value="Specify the contract if you only want to disable a specific use.  This field can be set to one of the following values, or to their combination (comma-separated): * ONECLICK * RECURRING * PAYOUT")
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContract(String contract) {
        this.contract = contract;
    }

    public DisableRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public DisableRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The ID that uniquely identifies the recurring detail reference.  If it is not provided, the whole recurring contract of the `shopperReference` will be disabled, which includes all recurring details.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public DisableRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID that uniquely identifies the shopper.  This `shopperReference` must be the same as the `shopperReference` used in the initial payment.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisableRequest disableRequest = (DisableRequest)o;
        return Objects.equals(this.contract, disableRequest.contract) && Objects.equals(this.merchantAccount, disableRequest.merchantAccount) && Objects.equals(this.recurringDetailReference, disableRequest.recurringDetailReference) && Objects.equals(this.shopperReference, disableRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.contract, this.merchantAccount, this.recurringDetailReference, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisableRequest {\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DisableRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DisableRequest)JSON.getMapper().readValue(jsonString, DisableRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

