/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "invalidFields", "newStatus", "oldStatus", "reason", "store", "storeReference"})
public class AccountHolderStoreStatusChangeNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_NEW_STATUS = "newStatus";
    private NewStatusEnum newStatus;
    public static final String JSON_PROPERTY_OLD_STATUS = "oldStatus";
    private OldStatusEnum oldStatus;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_STORE_REFERENCE = "storeReference";
    private String storeReference;

    public AccountHolderStoreStatusChangeNotificationContent accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderStoreStatusChangeNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public AccountHolderStoreStatusChangeNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="In case the store status has not been updated, contains fields that did not pass the validation.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public AccountHolderStoreStatusChangeNotificationContent newStatus(NewStatusEnum newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The new status of the account holder.")
    @JsonProperty(value="newStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NewStatusEnum getNewStatus() {
        return this.newStatus;
    }

    @JsonProperty(value="newStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewStatus(NewStatusEnum newStatus) {
        this.newStatus = newStatus;
    }

    public AccountHolderStoreStatusChangeNotificationContent oldStatus(OldStatusEnum oldStatus) {
        this.oldStatus = oldStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The former status of the account holder.")
    @JsonProperty(value="oldStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OldStatusEnum getOldStatus() {
        return this.oldStatus;
    }

    @JsonProperty(value="oldStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOldStatus(OldStatusEnum oldStatus) {
        this.oldStatus = oldStatus;
    }

    public AccountHolderStoreStatusChangeNotificationContent reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the status change.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public AccountHolderStoreStatusChangeNotificationContent store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(required=true, value="Alphanumeric identifier of the store.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public AccountHolderStoreStatusChangeNotificationContent storeReference(String storeReference) {
        this.storeReference = storeReference;
        return this;
    }

    @ApiModelProperty(required=true, value="Store store reference.")
    @JsonProperty(value="storeReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreReference() {
        return this.storeReference;
    }

    @JsonProperty(value="storeReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreReference(String storeReference) {
        this.storeReference = storeReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderStoreStatusChangeNotificationContent accountHolderStoreStatusChangeNotificationContent = (AccountHolderStoreStatusChangeNotificationContent)o;
        return Objects.equals(this.accountHolderCode, accountHolderStoreStatusChangeNotificationContent.accountHolderCode) && Objects.equals(this.invalidFields, accountHolderStoreStatusChangeNotificationContent.invalidFields) && Objects.equals((Object)this.newStatus, (Object)accountHolderStoreStatusChangeNotificationContent.newStatus) && Objects.equals((Object)this.oldStatus, (Object)accountHolderStoreStatusChangeNotificationContent.oldStatus) && Objects.equals(this.reason, accountHolderStoreStatusChangeNotificationContent.reason) && Objects.equals(this.store, accountHolderStoreStatusChangeNotificationContent.store) && Objects.equals(this.storeReference, accountHolderStoreStatusChangeNotificationContent.storeReference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.invalidFields, this.newStatus, this.oldStatus, this.reason, this.store, this.storeReference});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderStoreStatusChangeNotificationContent {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    newStatus: ").append(this.toIndentedString((Object)this.newStatus)).append("\n");
        sb.append("    oldStatus: ").append(this.toIndentedString((Object)this.oldStatus)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storeReference: ").append(this.toIndentedString(this.storeReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderStoreStatusChangeNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderStoreStatusChangeNotificationContent)JSON.getMapper().readValue(jsonString, AccountHolderStoreStatusChangeNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum OldStatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        INACTIVEWITHMODIFICATIONS("InactiveWithModifications"),
        PENDING("Pending");

        private String value;

        private OldStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OldStatusEnum fromValue(String value) {
            for (OldStatusEnum b : OldStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum NewStatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        INACTIVEWITHMODIFICATIONS("InactiveWithModifications"),
        PENDING("Pending");

        private String value;

        private NewStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewStatusEnum fromValue(String value) {
            for (NewStatusEnum b : NewStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

