/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TransferOperation
 */
@JsonPropertyOrder({
  TransferOperation.JSON_PROPERTY_DIRECTION,
  TransferOperation.JSON_PROPERTY_REFERENCE,
  TransferOperation.JSON_PROPERTY_TYPE
})

public class TransferOperation {
  public static final String JSON_PROPERTY_DIRECTION = "direction";
  private String direction;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public TransferOperation() { 
  }

  public TransferOperation direction(String direction) {
    this.direction = direction;
    return this;
  }

   /**
   * The direction of the money movement.
   * @return direction
  **/
  @ApiModelProperty(value = "The direction of the money movement.")
  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDirection() {
    return direction;
  }


  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDirection(String direction) {
    this.direction = direction;
  }


  public TransferOperation reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * The reference returned when the amend was initiated.
   * @return reference
  **/
  @ApiModelProperty(value = "The reference returned when the amend was initiated.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public TransferOperation type(String type) {
    this.type = type;
    return this;
  }

   /**
   * The type of amend for the transfer.
   * @return type
  **/
  @ApiModelProperty(value = "The type of amend for the transfer.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  /**
   * Return true if this TransferOperation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferOperation transferOperation = (TransferOperation) o;
    return Objects.equals(this.direction, transferOperation.direction) &&
        Objects.equals(this.reference, transferOperation.reference) &&
        Objects.equals(this.type, transferOperation.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(direction, reference, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferOperation {\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TransferOperation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferOperation
   * @throws JsonProcessingException if the JSON string is invalid with respect to TransferOperation
   */
  public static TransferOperation fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferOperation.class);
  }
/**
  * Convert an instance of TransferOperation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

