/*
 * Transfers API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Transaction
 */
@JsonPropertyOrder({
  Transaction.JSON_PROPERTY_ACCOUNT_HOLDER_ID,
  Transaction.JSON_PROPERTY_AMOUNT,
  Transaction.JSON_PROPERTY_BALANCE_ACCOUNT_ID,
  Transaction.JSON_PROPERTY_BALANCE_PLATFORM,
  Transaction.JSON_PROPERTY_BOOKING_DATE,
  Transaction.JSON_PROPERTY_CATEGORY,
  Transaction.JSON_PROPERTY_COUNTERPARTY,
  Transaction.JSON_PROPERTY_CREATED_AT,
  Transaction.JSON_PROPERTY_CREATION_DATE,
  Transaction.JSON_PROPERTY_DESCRIPTION,
  Transaction.JSON_PROPERTY_EVENT_ID,
  Transaction.JSON_PROPERTY_ID,
  Transaction.JSON_PROPERTY_INSTRUCTED_AMOUNT,
  Transaction.JSON_PROPERTY_PAYMENT_INSTRUMENT_ID,
  Transaction.JSON_PROPERTY_REFERENCE,
  Transaction.JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY,
  Transaction.JSON_PROPERTY_STATUS,
  Transaction.JSON_PROPERTY_TRANSFER_ID,
  Transaction.JSON_PROPERTY_TYPE,
  Transaction.JSON_PROPERTY_VALUE_DATE
})

public class Transaction {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
  private String accountHolderId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
  private String balanceAccountId;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
  private OffsetDateTime bookingDate;

  /**
   * The category of the transaction indicating the type of activity.   Possible values:  * **platformPayment**: The transaction is a payment or payment modification made with an Adyen merchant account.  * **internal**: The transaction resulted from an internal adjustment such as a deposit correction or invoice deduction.  * **bank**: The transaction is a bank-related activity, such as sending a payout or receiving funds.  * **issuedCard**: The transaction is a card-related activity, such as using an Adyen-issued card to pay online.  
   */
  public enum CategoryEnum {
    BANK("bank"),
    
    CARD("card"),
    
    GRANTS("grants"),
    
    INTERNAL("internal"),
    
    ISSUEDCARD("issuedCard"),
    
    MIGRATION("migration"),
    
    PLATFORMPAYMENT("platformPayment"),
    
    UPGRADE("upgrade");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private CategoryEnum category;

  public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
  private CounterpartyV3 counterparty;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_EVENT_ID = "eventId";
  private String eventId;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INSTRUCTED_AMOUNT = "instructedAmount";
  private Amount instructedAmount;

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
  private String paymentInstrumentId;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
  private String referenceForBeneficiary;

  /**
   * The status of the transaction.   Possible values:  * **pending**: The transaction is still pending.  * **booked**: The transaction has been booked to the balance account.  
   */
  public enum StatusEnum {
    BOOKED("booked"),
    
    PENDING("pending");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_TRANSFER_ID = "transferId";
  private String transferId;

  /**
   * The type of the transaction.   Possible values: **payment**, **capture**, **captureReversal**, **refund** **refundReversal**, **chargeback**, **chargebackReversal**, **secondChargeback**, **atmWithdrawal**, **atmWithdrawalReversal**, **internalTransfer**, **manualCorrection**, **invoiceDeduction**, **depositCorrection**, **bankTransfer**, **miscCost**, **paymentCost**, **fee**
   */
  public enum TypeEnum {
    ATMWITHDRAWAL("atmWithdrawal"),
    
    ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
    
    BALANCEADJUSTMENT("balanceAdjustment"),
    
    BALANCEMIGRATION("balanceMigration"),
    
    BALANCEROLLOVER("balanceRollover"),
    
    BANKTRANSFER("bankTransfer"),
    
    CAPTURE("capture"),
    
    CAPTUREREVERSAL("captureReversal"),
    
    CARDTRANSFER("cardTransfer"),
    
    CASHOUTFEE("cashOutFee"),
    
    CASHOUTFUNDING("cashOutFunding"),
    
    CASHOUTINSTRUCTION("cashOutInstruction"),
    
    CHARGEBACK("chargeback"),
    
    CHARGEBACKCORRECTION("chargebackCorrection"),
    
    CHARGEBACKREVERSAL("chargebackReversal"),
    
    CHARGEBACKREVERSALCORRECTION("chargebackReversalCorrection"),
    
    DEPOSITCORRECTION("depositCorrection"),
    
    FEE("fee"),
    
    GRANT("grant"),
    
    INSTALLMENT("installment"),
    
    INSTALLMENTREVERSAL("installmentReversal"),
    
    INTERNALTRANSFER("internalTransfer"),
    
    INVOICEDEDUCTION("invoiceDeduction"),
    
    LEFTOVER("leftover"),
    
    MANUALCORRECTION("manualCorrection"),
    
    MISCCOST("miscCost"),
    
    PAYMENT("payment"),
    
    PAYMENTCOST("paymentCost"),
    
    REFUND("refund"),
    
    REFUNDREVERSAL("refundReversal"),
    
    REPAYMENT("repayment"),
    
    RESERVEADJUSTMENT("reserveAdjustment"),
    
    SECONDCHARGEBACK("secondChargeback"),
    
    SECONDCHARGEBACKCORRECTION("secondChargebackCorrection");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VALUE_DATE = "valueDate";
  private OffsetDateTime valueDate;

  public Transaction() {
  }

  public Transaction accountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
    return this;
  }

   /**
   * Unique identifier of the account holder.
   * @return accountHolderId
  **/
  @ApiModelProperty(required = true, value = "Unique identifier of the account holder.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountHolderId() {
    return accountHolderId;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }


  public Transaction amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public Transaction balanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
    return this;
  }

   /**
   * Unique identifier of the balance account.
   * @return balanceAccountId
  **/
  @ApiModelProperty(required = true, value = "Unique identifier of the balance account.")
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceAccountId() {
    return balanceAccountId;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
  }


  public Transaction balancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

   /**
   * The unique identifier of the balance platform.
   * @return balancePlatform
  **/
  @ApiModelProperty(required = true, value = "The unique identifier of the balance platform.")
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalancePlatform() {
    return balancePlatform;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }


  public Transaction bookingDate(OffsetDateTime bookingDate) {
    this.bookingDate = bookingDate;
    return this;
  }

   /**
   * The date the transaction was booked into the balance account.
   * @return bookingDate
  **/
  @ApiModelProperty(required = true, value = "The date the transaction was booked into the balance account.")
  @JsonProperty(JSON_PROPERTY_BOOKING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getBookingDate() {
    return bookingDate;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingDate(OffsetDateTime bookingDate) {
    this.bookingDate = bookingDate;
  }


  public Transaction category(CategoryEnum category) {
    this.category = category;
    return this;
  }

   /**
   * The category of the transaction indicating the type of activity.   Possible values:  * **platformPayment**: The transaction is a payment or payment modification made with an Adyen merchant account.  * **internal**: The transaction resulted from an internal adjustment such as a deposit correction or invoice deduction.  * **bank**: The transaction is a bank-related activity, such as sending a payout or receiving funds.  * **issuedCard**: The transaction is a card-related activity, such as using an Adyen-issued card to pay online.  
   * @return category
  **/
  @ApiModelProperty(value = "The category of the transaction indicating the type of activity.   Possible values:  * **platformPayment**: The transaction is a payment or payment modification made with an Adyen merchant account.  * **internal**: The transaction resulted from an internal adjustment such as a deposit correction or invoice deduction.  * **bank**: The transaction is a bank-related activity, such as sending a payout or receiving funds.  * **issuedCard**: The transaction is a card-related activity, such as using an Adyen-issued card to pay online.  ")
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryEnum getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategory(CategoryEnum category) {
    this.category = category;
  }


  public Transaction counterparty(CounterpartyV3 counterparty) {
    this.counterparty = counterparty;
    return this;
  }

   /**
   * Get counterparty
   * @return counterparty
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COUNTERPARTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CounterpartyV3 getCounterparty() {
    return counterparty;
  }


  @JsonProperty(JSON_PROPERTY_COUNTERPARTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCounterparty(CounterpartyV3 counterparty) {
    this.counterparty = counterparty;
  }


  public Transaction createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The date the transaction was created.
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "The date the transaction was created.")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Transaction creationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
    return this;
  }

   /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
   * @return creationDate
  **/
  @ApiModelProperty(value = "The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public Transaction description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The &#x60;description&#x60; from the &#x60;/transfers&#x60; request.
   * @return description
  **/
  @ApiModelProperty(value = "The `description` from the `/transfers` request.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Transaction eventId(String eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * The PSP reference of the transaction in the journal.
   * @return eventId
  **/
  @ApiModelProperty(value = "The PSP reference of the transaction in the journal.")
  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEventId() {
    return eventId;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventId(String eventId) {
    this.eventId = eventId;
  }


  public Transaction id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the transaction.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The unique identifier of the transaction.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Transaction instructedAmount(Amount instructedAmount) {
    this.instructedAmount = instructedAmount;
    return this;
  }

   /**
   * Get instructedAmount
   * @return instructedAmount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INSTRUCTED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getInstructedAmount() {
    return instructedAmount;
  }


  @JsonProperty(JSON_PROPERTY_INSTRUCTED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstructedAmount(Amount instructedAmount) {
    this.instructedAmount = instructedAmount;
  }


  public Transaction paymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
    return this;
  }

   /**
   * The unique identifier of the payment instrument that was used for the transaction.
   * @return paymentInstrumentId
  **/
  @ApiModelProperty(value = "The unique identifier of the payment instrument that was used for the transaction.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentInstrumentId() {
    return paymentInstrumentId;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
  }


  public Transaction reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * The [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_reference) from the &#x60;/transfers&#x60; request. If you haven&#39;t provided any, Adyen generates a unique reference.
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "The [`reference`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_reference) from the `/transfers` request. If you haven't provided any, Adyen generates a unique reference.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public Transaction referenceForBeneficiary(String referenceForBeneficiary) {
    this.referenceForBeneficiary = referenceForBeneficiary;
    return this;
  }

   /**
   * The reference sent to or received from the counterparty.  * For outgoing funds, this is the [&#x60;referenceForBeneficiary&#x60;](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__resParam_referenceForBeneficiary) from the  [&#x60;/transfers&#x60;](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_referenceForBeneficiary) request.   * For incoming funds, this is the reference from the sender.
   * @return referenceForBeneficiary
  **/
  @ApiModelProperty(value = "The reference sent to or received from the counterparty.  * For outgoing funds, this is the [`referenceForBeneficiary`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__resParam_referenceForBeneficiary) from the  [`/transfers`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_referenceForBeneficiary) request.   * For incoming funds, this is the reference from the sender.")
  @JsonProperty(JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReferenceForBeneficiary() {
    return referenceForBeneficiary;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceForBeneficiary(String referenceForBeneficiary) {
    this.referenceForBeneficiary = referenceForBeneficiary;
  }


  public Transaction status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * The status of the transaction.   Possible values:  * **pending**: The transaction is still pending.  * **booked**: The transaction has been booked to the balance account.  
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The status of the transaction.   Possible values:  * **pending**: The transaction is still pending.  * **booked**: The transaction has been booked to the balance account.  ")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Transaction transferId(String transferId) {
    this.transferId = transferId;
    return this;
  }

   /**
   * Unique identifier of the related transfer.
   * @return transferId
  **/
  @ApiModelProperty(value = "Unique identifier of the related transfer.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransferId() {
    return transferId;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferId(String transferId) {
    this.transferId = transferId;
  }


  public Transaction type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of the transaction.   Possible values: **payment**, **capture**, **captureReversal**, **refund** **refundReversal**, **chargeback**, **chargebackReversal**, **secondChargeback**, **atmWithdrawal**, **atmWithdrawalReversal**, **internalTransfer**, **manualCorrection**, **invoiceDeduction**, **depositCorrection**, **bankTransfer**, **miscCost**, **paymentCost**, **fee**
   * @return type
  **/
  @ApiModelProperty(value = "The type of the transaction.   Possible values: **payment**, **capture**, **captureReversal**, **refund** **refundReversal**, **chargeback**, **chargebackReversal**, **secondChargeback**, **atmWithdrawal**, **atmWithdrawalReversal**, **internalTransfer**, **manualCorrection**, **invoiceDeduction**, **depositCorrection**, **bankTransfer**, **miscCost**, **paymentCost**, **fee**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Transaction valueDate(OffsetDateTime valueDate) {
    this.valueDate = valueDate;
    return this;
  }

   /**
   * The date the transfer amount becomes available in the balance account.
   * @return valueDate
  **/
  @ApiModelProperty(required = true, value = "The date the transfer amount becomes available in the balance account.")
  @JsonProperty(JSON_PROPERTY_VALUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getValueDate() {
    return valueDate;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueDate(OffsetDateTime valueDate) {
    this.valueDate = valueDate;
  }


  /**
   * Return true if this Transaction object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Transaction transaction = (Transaction) o;
    return Objects.equals(this.accountHolderId, transaction.accountHolderId) &&
        Objects.equals(this.amount, transaction.amount) &&
        Objects.equals(this.balanceAccountId, transaction.balanceAccountId) &&
        Objects.equals(this.balancePlatform, transaction.balancePlatform) &&
        Objects.equals(this.bookingDate, transaction.bookingDate) &&
        Objects.equals(this.category, transaction.category) &&
        Objects.equals(this.counterparty, transaction.counterparty) &&
        Objects.equals(this.createdAt, transaction.createdAt) &&
        Objects.equals(this.creationDate, transaction.creationDate) &&
        Objects.equals(this.description, transaction.description) &&
        Objects.equals(this.eventId, transaction.eventId) &&
        Objects.equals(this.id, transaction.id) &&
        Objects.equals(this.instructedAmount, transaction.instructedAmount) &&
        Objects.equals(this.paymentInstrumentId, transaction.paymentInstrumentId) &&
        Objects.equals(this.reference, transaction.reference) &&
        Objects.equals(this.referenceForBeneficiary, transaction.referenceForBeneficiary) &&
        Objects.equals(this.status, transaction.status) &&
        Objects.equals(this.transferId, transaction.transferId) &&
        Objects.equals(this.type, transaction.type) &&
        Objects.equals(this.valueDate, transaction.valueDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderId, amount, balanceAccountId, balancePlatform, bookingDate, category, counterparty, createdAt, creationDate, description, eventId, id, instructedAmount, paymentInstrumentId, reference, referenceForBeneficiary, status, transferId, type, valueDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Transaction {\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balanceAccountId: ").append(toIndentedString(balanceAccountId)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    bookingDate: ").append(toIndentedString(bookingDate)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    counterparty: ").append(toIndentedString(counterparty)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    instructedAmount: ").append(toIndentedString(instructedAmount)).append("\n");
    sb.append("    paymentInstrumentId: ").append(toIndentedString(paymentInstrumentId)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    referenceForBeneficiary: ").append(toIndentedString(referenceForBeneficiary)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    transferId: ").append(toIndentedString(transferId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    valueDate: ").append(toIndentedString(valueDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Transaction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Transaction
   * @throws JsonProcessingException if the JSON string is invalid with respect to Transaction
   */
  public static Transaction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Transaction.class);
  }
/**
  * Convert an instance of Transaction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

