/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayaccount;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayaccount.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AccountProcessingState
 */
@JsonPropertyOrder({
  AccountProcessingState.JSON_PROPERTY_DISABLE_REASON,
  AccountProcessingState.JSON_PROPERTY_DISABLED,
  AccountProcessingState.JSON_PROPERTY_PROCESSED_FROM,
  AccountProcessingState.JSON_PROPERTY_PROCESSED_TO,
  AccountProcessingState.JSON_PROPERTY_TIER_NUMBER
})

public class AccountProcessingState {
  public static final String JSON_PROPERTY_DISABLE_REASON = "disableReason";
  private String disableReason;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public static final String JSON_PROPERTY_PROCESSED_FROM = "processedFrom";
  private Amount processedFrom;

  public static final String JSON_PROPERTY_PROCESSED_TO = "processedTo";
  private Amount processedTo;

  public static final String JSON_PROPERTY_TIER_NUMBER = "tierNumber";
  private Integer tierNumber;

  public AccountProcessingState() { 
  }

  public AccountProcessingState disableReason(String disableReason) {
    this.disableReason = disableReason;
    return this;
  }

   /**
   * The reason why processing has been disabled.
   * @return disableReason
  **/
  @ApiModelProperty(value = "The reason why processing has been disabled.")
  @JsonProperty(JSON_PROPERTY_DISABLE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisableReason() {
    return disableReason;
  }


  @JsonProperty(JSON_PROPERTY_DISABLE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisableReason(String disableReason) {
    this.disableReason = disableReason;
  }


  public AccountProcessingState disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

   /**
   * Indicates whether the processing of payments is allowed.
   * @return disabled
  **/
  @ApiModelProperty(value = "Indicates whether the processing of payments is allowed.")
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisabled() {
    return disabled;
  }


  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }


  public AccountProcessingState processedFrom(Amount processedFrom) {
    this.processedFrom = processedFrom;
    return this;
  }

   /**
   * Get processedFrom
   * @return processedFrom
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROCESSED_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getProcessedFrom() {
    return processedFrom;
  }


  @JsonProperty(JSON_PROPERTY_PROCESSED_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessedFrom(Amount processedFrom) {
    this.processedFrom = processedFrom;
  }


  public AccountProcessingState processedTo(Amount processedTo) {
    this.processedTo = processedTo;
    return this;
  }

   /**
   * Get processedTo
   * @return processedTo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROCESSED_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getProcessedTo() {
    return processedTo;
  }


  @JsonProperty(JSON_PROPERTY_PROCESSED_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessedTo(Amount processedTo) {
    this.processedTo = processedTo;
  }


  public AccountProcessingState tierNumber(Integer tierNumber) {
    this.tierNumber = tierNumber;
    return this;
  }

   /**
   * The processing tier that the account holder occupies.
   * @return tierNumber
  **/
  @ApiModelProperty(value = "The processing tier that the account holder occupies.")
  @JsonProperty(JSON_PROPERTY_TIER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTierNumber() {
    return tierNumber;
  }


  @JsonProperty(JSON_PROPERTY_TIER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTierNumber(Integer tierNumber) {
    this.tierNumber = tierNumber;
  }


  /**
   * Return true if this AccountProcessingState object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountProcessingState accountProcessingState = (AccountProcessingState) o;
    return Objects.equals(this.disableReason, accountProcessingState.disableReason) &&
        Objects.equals(this.disabled, accountProcessingState.disabled) &&
        Objects.equals(this.processedFrom, accountProcessingState.processedFrom) &&
        Objects.equals(this.processedTo, accountProcessingState.processedTo) &&
        Objects.equals(this.tierNumber, accountProcessingState.tierNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(disableReason, disabled, processedFrom, processedTo, tierNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountProcessingState {\n");
    sb.append("    disableReason: ").append(toIndentedString(disableReason)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    processedFrom: ").append(toIndentedString(processedFrom)).append("\n");
    sb.append("    processedTo: ").append(toIndentedString(processedTo)).append("\n");
    sb.append("    tierNumber: ").append(toIndentedString(tierNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AccountProcessingState given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountProcessingState
   * @throws JsonProcessingException if the JSON string is invalid with respect to AccountProcessingState
   */
  public static AccountProcessingState fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AccountProcessingState.class);
  }
/**
  * Convert an instance of AccountProcessingState to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

