/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Connectivity
 */
@JsonPropertyOrder({
  Connectivity.JSON_PROPERTY_SIMCARD_STATUS
})

public class Connectivity {
  /**
   * Indicates the status of the SIM card in the payment terminal. Can be updated and received only at terminal level, and only for models that support cellular connectivity.  Possible values: * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not activated. The terminal can&#39;t use cellular connectivity.
   */
  public enum SimcardStatusEnum {
    ACTIVATED("ACTIVATED"),
    
    INVENTORY("INVENTORY");

    private String value;

    SimcardStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SimcardStatusEnum fromValue(String value) {
      for (SimcardStatusEnum b : SimcardStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SIMCARD_STATUS = "simcardStatus";
  private SimcardStatusEnum simcardStatus;

  public Connectivity() { 
  }

  public Connectivity simcardStatus(SimcardStatusEnum simcardStatus) {
    this.simcardStatus = simcardStatus;
    return this;
  }

   /**
   * Indicates the status of the SIM card in the payment terminal. Can be updated and received only at terminal level, and only for models that support cellular connectivity.  Possible values: * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not activated. The terminal can&#39;t use cellular connectivity.
   * @return simcardStatus
  **/
  @ApiModelProperty(value = "Indicates the status of the SIM card in the payment terminal. Can be updated and received only at terminal level, and only for models that support cellular connectivity.  Possible values: * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not activated. The terminal can't use cellular connectivity.")
  @JsonProperty(JSON_PROPERTY_SIMCARD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimcardStatusEnum getSimcardStatus() {
    return simcardStatus;
  }


  @JsonProperty(JSON_PROPERTY_SIMCARD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSimcardStatus(SimcardStatusEnum simcardStatus) {
    this.simcardStatus = simcardStatus;
  }


  /**
   * Return true if this Connectivity object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Connectivity connectivity = (Connectivity) o;
    return Objects.equals(this.simcardStatus, connectivity.simcardStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(simcardStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Connectivity {\n");
    sb.append("    simcardStatus: ").append(toIndentedString(simcardStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Connectivity given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Connectivity
   * @throws JsonProcessingException if the JSON string is invalid with respect to Connectivity
   */
  public static Connectivity fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Connectivity.class);
  }
/**
  * Convert an instance of Connectivity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

