/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.terminal.serialization;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlEnumValue;

public class XMLEnumTypeAdapter<T>
extends TypeAdapter<T> {
    private final Class clazz;

    public XMLEnumTypeAdapter(Class clazz) {
        this.clazz = clazz;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null || !value.getClass().isEnum()) {
            out.nullValue();
            return;
        }
        Enum enumValue = (Enum)value;
        try {
            if (enumValue.getClass().getField(enumValue.name()).getAnnotation(XmlEnumValue.class) != null) {
                XmlEnumValue xmlEnumValue = enumValue.getClass().getField(enumValue.name()).getAnnotation(XmlEnumValue.class);
                out.value(xmlEnumValue.value());
            } else {
                out.value(enumValue.name());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public T read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String value = in.nextString();
        Object enumObject = null;
        try {
            Method[] methods;
            for (Method m : methods = this.clazz.getMethods()) {
                if (!"fromValue".equals(m.getName())) continue;
                enumObject = m.invoke(null, value);
            }
            if (enumObject == null) {
                enumObject = Enum.valueOf(Enum.class, value);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return (T)enumObject;
    }
}

