/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.AndroidAppsResponse;
import com.adyen.model.management.AndroidCertificatesResponse;
import com.adyen.model.management.ExternalTerminalAction;
import com.adyen.model.management.ListExternalTerminalActionsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalActionsCompanyLevelApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public TerminalActionsCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v1");
    }

    public TerminalActionsCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public AndroidAppsResponse listAndroidApps(String companyId) throws ApiException, IOException {
        return this.listAndroidApps(companyId, null, null, null, null, null);
    }

    public AndroidAppsResponse listAndroidApps(String companyId, Integer pageNumber, Integer pageSize, String packageName, Integer versionCode, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (packageName != null) {
            queryParams.put("packageName", packageName);
        }
        if (versionCode != null) {
            queryParams.put("versionCode", versionCode.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return AndroidAppsResponse.fromJson(jsonResult);
    }

    public AndroidCertificatesResponse listAndroidCertificates(String companyId) throws ApiException, IOException {
        return this.listAndroidCertificates(companyId, null, null, null, null);
    }

    public AndroidCertificatesResponse listAndroidCertificates(String companyId, Integer pageNumber, Integer pageSize, String certificateName, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (certificateName != null) {
            queryParams.put("certificateName", certificateName);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidCertificates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return AndroidCertificatesResponse.fromJson(jsonResult);
    }

    public ListExternalTerminalActionsResponse listTerminalActions(String companyId) throws ApiException, IOException {
        return this.listTerminalActions(companyId, null, null, null, null, null);
    }

    public ListExternalTerminalActionsResponse listTerminalActions(String companyId, Integer pageNumber, Integer pageSize, String status, String type, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (status != null) {
            queryParams.put("status", status);
        }
        if (type != null) {
            queryParams.put("type", type);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalActions", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListExternalTerminalActionsResponse.fromJson(jsonResult);
    }

    public ExternalTerminalAction getTerminalAction(String companyId, String actionId) throws ApiException, IOException {
        return this.getTerminalAction(companyId, actionId, null);
    }

    public ExternalTerminalAction getTerminalAction(String companyId, String actionId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (actionId == null) {
            throw new IllegalArgumentException("Please provide the actionId path parameter");
        }
        pathParams.put("actionId", actionId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalActions/{actionId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return ExternalTerminalAction.fromJson(jsonResult);
    }
}

