/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.AllowedOriginsResponse;
import com.adyen.model.management.CreateAllowedOriginRequest;
import com.adyen.model.management.MeApiCredential;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class MyApiCredentialApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public MyApiCredentialApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v1");
    }

    public MyApiCredentialApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void removeAllowedOrigin(String originId) throws ApiException, IOException {
        this.removeAllowedOrigin(originId, null);
    }

    public void removeAllowedOrigin(String originId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (originId == null) {
            throw new IllegalArgumentException("Please provide the originId path parameter");
        }
        pathParams.put("originId", originId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/me/allowedOrigins/{originId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public MeApiCredential getApiCredentialDetails() throws ApiException, IOException {
        return this.getApiCredentialDetails(null);
    }

    public MeApiCredential getApiCredentialDetails(RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/me", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null);
        return MeApiCredential.fromJson(jsonResult);
    }

    public AllowedOriginsResponse getAllowedOrigins() throws ApiException, IOException {
        return this.getAllowedOrigins(null);
    }

    public AllowedOriginsResponse getAllowedOrigins(RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/me/allowedOrigins", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null);
        return AllowedOriginsResponse.fromJson(jsonResult);
    }

    public AllowedOrigin getAllowedOriginDetails(String originId) throws ApiException, IOException {
        return this.getAllowedOriginDetails(originId, null);
    }

    public AllowedOrigin getAllowedOriginDetails(String originId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (originId == null) {
            throw new IllegalArgumentException("Please provide the originId path parameter");
        }
        pathParams.put("originId", originId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/me/allowedOrigins/{originId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AllowedOrigin.fromJson(jsonResult);
    }

    public AllowedOrigin addAllowedOrigin(CreateAllowedOriginRequest createAllowedOriginRequest) throws ApiException, IOException {
        return this.addAllowedOrigin(createAllowedOriginRequest, null);
    }

    public AllowedOrigin addAllowedOrigin(CreateAllowedOriginRequest createAllowedOriginRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = createAllowedOriginRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/me/allowedOrigins", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AllowedOrigin.fromJson(jsonResult);
    }
}

