/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.BalanceAccount;
import com.adyen.model.balanceplatform.BalanceAccountInfo;
import com.adyen.model.balanceplatform.BalanceAccountUpdateRequest;
import com.adyen.model.balanceplatform.BalanceSweepConfigurationsResponse;
import com.adyen.model.balanceplatform.PaginatedPaymentInstrumentsResponse;
import com.adyen.model.balanceplatform.SweepConfigurationV2;
import com.adyen.model.balanceplatform.UpdateSweepConfigurationV2;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class BalanceAccountsApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public BalanceAccountsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public BalanceAccountsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void deleteSweep(String balanceAccountId, String sweepId) throws ApiException, IOException {
        this.deleteSweep(balanceAccountId, sweepId, null);
    }

    public void deleteSweep(String balanceAccountId, String sweepId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balanceAccountId == null) {
            throw new IllegalArgumentException("Please provide the balanceAccountId path parameter");
        }
        pathParams.put("balanceAccountId", balanceAccountId);
        if (sweepId == null) {
            throw new IllegalArgumentException("Please provide the sweepId path parameter");
        }
        pathParams.put("sweepId", sweepId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{balanceAccountId}/sweeps/{sweepId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public BalanceSweepConfigurationsResponse getAllSweepsForBalanceAccount(String balanceAccountId) throws ApiException, IOException {
        return this.getAllSweepsForBalanceAccount(balanceAccountId, null, null, null);
    }

    public BalanceSweepConfigurationsResponse getAllSweepsForBalanceAccount(String balanceAccountId, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balanceAccountId == null) {
            throw new IllegalArgumentException("Please provide the balanceAccountId path parameter");
        }
        pathParams.put("balanceAccountId", balanceAccountId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{balanceAccountId}/sweeps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return BalanceSweepConfigurationsResponse.fromJson(jsonResult);
    }

    public SweepConfigurationV2 getSweep(String balanceAccountId, String sweepId) throws ApiException, IOException {
        return this.getSweep(balanceAccountId, sweepId, null);
    }

    public SweepConfigurationV2 getSweep(String balanceAccountId, String sweepId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balanceAccountId == null) {
            throw new IllegalArgumentException("Please provide the balanceAccountId path parameter");
        }
        pathParams.put("balanceAccountId", balanceAccountId);
        if (sweepId == null) {
            throw new IllegalArgumentException("Please provide the sweepId path parameter");
        }
        pathParams.put("sweepId", sweepId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{balanceAccountId}/sweeps/{sweepId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return SweepConfigurationV2.fromJson(jsonResult);
    }

    public BalanceAccount getBalanceAccount(String id) throws ApiException, IOException {
        return this.getBalanceAccount(id, null);
    }

    public BalanceAccount getBalanceAccount(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return BalanceAccount.fromJson(jsonResult);
    }

    public PaginatedPaymentInstrumentsResponse getAllPaymentInstrumentsForBalanceAccount(String id) throws ApiException, IOException {
        return this.getAllPaymentInstrumentsForBalanceAccount(id, null, null, null);
    }

    public PaginatedPaymentInstrumentsResponse getAllPaymentInstrumentsForBalanceAccount(String id, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/paymentInstruments", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaginatedPaymentInstrumentsResponse.fromJson(jsonResult);
    }

    public SweepConfigurationV2 updateSweep(String balanceAccountId, String sweepId, UpdateSweepConfigurationV2 updateSweepConfigurationV2) throws ApiException, IOException {
        return this.updateSweep(balanceAccountId, sweepId, updateSweepConfigurationV2, null);
    }

    public SweepConfigurationV2 updateSweep(String balanceAccountId, String sweepId, UpdateSweepConfigurationV2 updateSweepConfigurationV2, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balanceAccountId == null) {
            throw new IllegalArgumentException("Please provide the balanceAccountId path parameter");
        }
        pathParams.put("balanceAccountId", balanceAccountId);
        if (sweepId == null) {
            throw new IllegalArgumentException("Please provide the sweepId path parameter");
        }
        pathParams.put("sweepId", sweepId);
        String requestBody = updateSweepConfigurationV2.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{balanceAccountId}/sweeps/{sweepId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return SweepConfigurationV2.fromJson(jsonResult);
    }

    public BalanceAccount updateBalanceAccount(String id, BalanceAccountUpdateRequest balanceAccountUpdateRequest) throws ApiException, IOException {
        return this.updateBalanceAccount(id, balanceAccountUpdateRequest, null);
    }

    public BalanceAccount updateBalanceAccount(String id, BalanceAccountUpdateRequest balanceAccountUpdateRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = balanceAccountUpdateRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return BalanceAccount.fromJson(jsonResult);
    }

    public BalanceAccount createBalanceAccount(BalanceAccountInfo balanceAccountInfo) throws ApiException, IOException {
        return this.createBalanceAccount(balanceAccountInfo, null);
    }

    public BalanceAccount createBalanceAccount(BalanceAccountInfo balanceAccountInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = balanceAccountInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return BalanceAccount.fromJson(jsonResult);
    }

    public SweepConfigurationV2 createSweep(String balanceAccountId, SweepConfigurationV2 sweepConfigurationV2) throws ApiException, IOException {
        return this.createSweep(balanceAccountId, sweepConfigurationV2, null);
    }

    public SweepConfigurationV2 createSweep(String balanceAccountId, SweepConfigurationV2 sweepConfigurationV2, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balanceAccountId == null) {
            throw new IllegalArgumentException("Please provide the balanceAccountId path parameter");
        }
        pathParams.put("balanceAccountId", balanceAccountId);
        String requestBody = sweepConfigurationV2.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{balanceAccountId}/sweeps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return SweepConfigurationV2.fromJson(jsonResult);
    }
}

