/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.SplitConfiguration;
import com.adyen.model.management.SplitConfigurationList;
import com.adyen.model.management.SplitConfigurationRule;
import com.adyen.model.management.UpdateSplitConfigurationLogicRequest;
import com.adyen.model.management.UpdateSplitConfigurationRequest;
import com.adyen.model.management.UpdateSplitConfigurationRuleRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class SplitConfigurationMerchantLevelApi
extends Service {
    protected String baseURL = this.createBaseURL("https://management-test.adyen.com/v1");

    public SplitConfigurationMerchantLevelApi(Client client) {
        super(client);
    }

    public SplitConfiguration deleteSplitConfiguration(String merchantId, String splitConfigurationId) throws ApiException, IOException {
        return this.deleteSplitConfiguration(merchantId, splitConfigurationId, null);
    }

    public SplitConfiguration deleteSplitConfiguration(String merchantId, String splitConfigurationId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfiguration deleteSplitConfigurationRule(String merchantId, String splitConfigurationId, String ruleId) throws ApiException, IOException {
        return this.deleteSplitConfigurationRule(merchantId, splitConfigurationId, ruleId, null);
    }

    public SplitConfiguration deleteSplitConfigurationRule(String merchantId, String splitConfigurationId, String ruleId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        if (ruleId == null) {
            throw new IllegalArgumentException("Please provide the ruleId path parameter");
        }
        pathParams.put("ruleId", ruleId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}/rules/{ruleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfigurationList listSplitConfigurations(String merchantId) throws ApiException, IOException {
        return this.listSplitConfigurations(merchantId, null);
    }

    public SplitConfigurationList listSplitConfigurations(String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return SplitConfigurationList.fromJson(jsonResult);
    }

    public SplitConfiguration getSplitConfiguration(String merchantId, String splitConfigurationId) throws ApiException, IOException {
        return this.getSplitConfiguration(merchantId, splitConfigurationId, null);
    }

    public SplitConfiguration getSplitConfiguration(String merchantId, String splitConfigurationId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfiguration updateSplitConfigurationDescription(String merchantId, String splitConfigurationId, UpdateSplitConfigurationRequest updateSplitConfigurationRequest) throws ApiException, IOException {
        return this.updateSplitConfigurationDescription(merchantId, splitConfigurationId, updateSplitConfigurationRequest, null);
    }

    public SplitConfiguration updateSplitConfigurationDescription(String merchantId, String splitConfigurationId, UpdateSplitConfigurationRequest updateSplitConfigurationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        String requestBody = updateSplitConfigurationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfiguration updateSplitConditions(String merchantId, String splitConfigurationId, String ruleId, UpdateSplitConfigurationRuleRequest updateSplitConfigurationRuleRequest) throws ApiException, IOException {
        return this.updateSplitConditions(merchantId, splitConfigurationId, ruleId, updateSplitConfigurationRuleRequest, null);
    }

    public SplitConfiguration updateSplitConditions(String merchantId, String splitConfigurationId, String ruleId, UpdateSplitConfigurationRuleRequest updateSplitConfigurationRuleRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        if (ruleId == null) {
            throw new IllegalArgumentException("Please provide the ruleId path parameter");
        }
        pathParams.put("ruleId", ruleId);
        String requestBody = updateSplitConfigurationRuleRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}/rules/{ruleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfiguration updateSplitLogic(String merchantId, String splitConfigurationId, String ruleId, String splitLogicId, UpdateSplitConfigurationLogicRequest updateSplitConfigurationLogicRequest) throws ApiException, IOException {
        return this.updateSplitLogic(merchantId, splitConfigurationId, ruleId, splitLogicId, updateSplitConfigurationLogicRequest, null);
    }

    public SplitConfiguration updateSplitLogic(String merchantId, String splitConfigurationId, String ruleId, String splitLogicId, UpdateSplitConfigurationLogicRequest updateSplitConfigurationLogicRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        if (ruleId == null) {
            throw new IllegalArgumentException("Please provide the ruleId path parameter");
        }
        pathParams.put("ruleId", ruleId);
        if (splitLogicId == null) {
            throw new IllegalArgumentException("Please provide the splitLogicId path parameter");
        }
        pathParams.put("splitLogicId", splitLogicId);
        String requestBody = updateSplitConfigurationLogicRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}/rules/{ruleId}/splitLogic/{splitLogicId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfiguration createSplitConfiguration(String merchantId, SplitConfiguration splitConfiguration) throws ApiException, IOException {
        return this.createSplitConfiguration(merchantId, splitConfiguration, null);
    }

    public SplitConfiguration createSplitConfiguration(String merchantId, SplitConfiguration splitConfiguration, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = splitConfiguration.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }

    public SplitConfiguration createRule(String merchantId, String splitConfigurationId, SplitConfigurationRule splitConfigurationRule) throws ApiException, IOException {
        return this.createRule(merchantId, splitConfigurationId, splitConfigurationRule, null);
    }

    public SplitConfiguration createRule(String merchantId, String splitConfigurationId, SplitConfigurationRule splitConfigurationRule, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (splitConfigurationId == null) {
            throw new IllegalArgumentException("Please provide the splitConfigurationId path parameter");
        }
        pathParams.put("splitConfigurationId", splitConfigurationId);
        String requestBody = splitConfigurationRule.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/splitConfigurations/{splitConfigurationId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return SplitConfiguration.fromJson(jsonResult);
    }
}

