/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.ListNetworkTokensResponse;
import com.adyen.model.balanceplatform.PaymentInstrument;
import com.adyen.model.balanceplatform.PaymentInstrumentInfo;
import com.adyen.model.balanceplatform.PaymentInstrumentRevealInfo;
import com.adyen.model.balanceplatform.PaymentInstrumentUpdateRequest;
import com.adyen.model.balanceplatform.TransactionRulesResponse;
import com.adyen.model.balanceplatform.UpdatePaymentInstrument;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PaymentInstrumentsApi
extends Service {
    protected String baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");

    public PaymentInstrumentsApi(Client client) {
        super(client);
    }

    public PaymentInstrument getPaymentInstrument(String id) throws ApiException, IOException {
        return this.getPaymentInstrument(id, null);
    }

    public PaymentInstrument getPaymentInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentInstrument.fromJson(jsonResult);
    }

    public ListNetworkTokensResponse listNetworkTokens(String id) throws ApiException, IOException {
        return this.listNetworkTokens(id, null);
    }

    public ListNetworkTokensResponse listNetworkTokens(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}/networkTokens", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return ListNetworkTokensResponse.fromJson(jsonResult);
    }

    public PaymentInstrumentRevealInfo getPanOfPaymentInstrument(String id) throws ApiException, IOException {
        return this.getPanOfPaymentInstrument(id, null);
    }

    public PaymentInstrumentRevealInfo getPanOfPaymentInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}/reveal", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentInstrumentRevealInfo.fromJson(jsonResult);
    }

    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrument(String id) throws ApiException, IOException {
        return this.getAllTransactionRulesForPaymentInstrument(id, null);
    }

    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}/transactionRules", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransactionRulesResponse.fromJson(jsonResult);
    }

    public UpdatePaymentInstrument updatePaymentInstrument(String id, PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest) throws ApiException, IOException {
        return this.updatePaymentInstrument(id, paymentInstrumentUpdateRequest, null);
    }

    public UpdatePaymentInstrument updatePaymentInstrument(String id, PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = paymentInstrumentUpdateRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return UpdatePaymentInstrument.fromJson(jsonResult);
    }

    public PaymentInstrument createPaymentInstrument(PaymentInstrumentInfo paymentInstrumentInfo) throws ApiException, IOException {
        return this.createPaymentInstrument(paymentInstrumentInfo, null);
    }

    public PaymentInstrument createPaymentInstrument(PaymentInstrumentInfo paymentInstrumentInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentInstrumentInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentInstrument.fromJson(jsonResult);
    }
}

