/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"capabilities", "entityAssociations", "individual", "organization", "reference", "soleProprietorship", "type"})
public class LegalEntityInfo {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, LegalEntityCapability> capabilities = null;
    public static final String JSON_PROPERTY_ENTITY_ASSOCIATIONS = "entityAssociations";
    private List<LegalEntityAssociation> entityAssociations = null;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private Individual individual;
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private Organization organization;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SOLE_PROPRIETORSHIP = "soleProprietorship";
    private SoleProprietorship soleProprietorship;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public LegalEntityInfo capabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public LegalEntityInfo putCapabilitiesItem(String key, LegalEntityCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, LegalEntityCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that the legal entity can do in your platform.The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
    }

    public LegalEntityInfo entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        return this;
    }

    public LegalEntityInfo addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @ApiModelProperty(value="List of legal entities associated with the current legal entity. For example, ultimate beneficial owners associated with an organization through ownership or control, or as signatories.")
    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
    }

    public LegalEntityInfo individual(Individual individual) {
        this.individual = individual;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Individual getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    public LegalEntityInfo organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public LegalEntityInfo reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the legal entity, maximum 150 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public LegalEntityInfo soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
    }

    public LegalEntityInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of legal entity.   Possible values: **individual**, **organization**, or **soleProprietorship**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityInfo legalEntityInfo = (LegalEntityInfo)o;
        return Objects.equals(this.capabilities, legalEntityInfo.capabilities) && Objects.equals(this.entityAssociations, legalEntityInfo.entityAssociations) && Objects.equals(this.individual, legalEntityInfo.individual) && Objects.equals(this.organization, legalEntityInfo.organization) && Objects.equals(this.reference, legalEntityInfo.reference) && Objects.equals(this.soleProprietorship, legalEntityInfo.soleProprietorship) && Objects.equals((Object)this.type, (Object)legalEntityInfo.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.entityAssociations, this.individual, this.organization, this.reference, this.soleProprietorship, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityInfo {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalEntityInfo fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntityInfo)JSON.getMapper().readValue(jsonString, LegalEntityInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        INDIVIDUAL("individual"),
        ORGANIZATION("organization"),
        SOLEPROPRIETORSHIP("soleProprietorship"),
        TRUST("trust"),
        UNINCORPORATEDPARTNERSHIP("unincorporatedPartnership");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

