/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balancecontrol;

import com.adyen.model.balancecontrol.Amount;
import com.adyen.model.balancecontrol.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "createdAt", "description", "fromMerchant", "pspReference", "reference", "status", "toMerchant", "type"})
public class BalanceTransferResponse {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FROM_MERCHANT = "fromMerchant";
    private String fromMerchant;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TO_MERCHANT = "toMerchant";
    private String toMerchant;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public BalanceTransferResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public BalanceTransferResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when the balance transfer was requested.")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BalanceTransferResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A human-readable description for the transfer. You can use alphanumeric characters and hyphens. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceTransferResponse fromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the source merchant account from which funds are deducted.")
    @JsonProperty(value="fromMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFromMerchant() {
        return this.fromMerchant;
    }

    @JsonProperty(value="fromMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
    }

    public BalanceTransferResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="Adyen's 16-character string reference associated with the balance transfer.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public BalanceTransferResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="A reference for the balance transfer. If you don't provide this in the request, Adyen generates a unique reference. Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceTransferResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the balance transfer. Possible values: **transferred**, **failed**, **error**, and **notEnoughBalance**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BalanceTransferResponse toMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the destination merchant account from which funds are transferred.")
    @JsonProperty(value="toMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToMerchant() {
        return this.toMerchant;
    }

    @JsonProperty(value="toMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
    }

    public BalanceTransferResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of balance transfer. Possible values: **tax**, **fee**, **terminalSale**, **credit**, **debit**, and **adjustment**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferResponse balanceTransferResponse = (BalanceTransferResponse)o;
        return Objects.equals(this.amount, balanceTransferResponse.amount) && Objects.equals(this.createdAt, balanceTransferResponse.createdAt) && Objects.equals(this.description, balanceTransferResponse.description) && Objects.equals(this.fromMerchant, balanceTransferResponse.fromMerchant) && Objects.equals(this.pspReference, balanceTransferResponse.pspReference) && Objects.equals(this.reference, balanceTransferResponse.reference) && Objects.equals((Object)this.status, (Object)balanceTransferResponse.status) && Objects.equals(this.toMerchant, balanceTransferResponse.toMerchant) && Objects.equals((Object)this.type, (Object)balanceTransferResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.createdAt, this.description, this.fromMerchant, this.pspReference, this.reference, this.status, this.toMerchant, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferResponse {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromMerchant: ").append(this.toIndentedString(this.fromMerchant)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    toMerchant: ").append(this.toIndentedString(this.toMerchant)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceTransferResponse fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceTransferResponse)JSON.getMapper().readValue(jsonString, BalanceTransferResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        TAX("tax"),
        FEE("fee"),
        TERMINALSALE("terminalSale"),
        CREDIT("credit"),
        DEBIT("debit"),
        ADJUSTMENT("adjustment");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ERROR("error"),
        FAILED("failed"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        TRANSFERRED("transferred");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

