/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"displayMaximumBackLight", "restartHour"})
public class Hardware {
    public static final String JSON_PROPERTY_DISPLAY_MAXIMUM_BACK_LIGHT = "displayMaximumBackLight";
    private Integer displayMaximumBackLight;
    public static final String JSON_PROPERTY_RESTART_HOUR = "restartHour";
    private Integer restartHour;

    public Hardware displayMaximumBackLight(Integer displayMaximumBackLight) {
        this.displayMaximumBackLight = displayMaximumBackLight;
        return this;
    }

    @ApiModelProperty(value="The brightness of the display when the terminal is being used, expressed as a percentage.")
    @JsonProperty(value="displayMaximumBackLight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDisplayMaximumBackLight() {
        return this.displayMaximumBackLight;
    }

    @JsonProperty(value="displayMaximumBackLight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayMaximumBackLight(Integer displayMaximumBackLight) {
        this.displayMaximumBackLight = displayMaximumBackLight;
    }

    public Hardware restartHour(Integer restartHour) {
        this.restartHour = restartHour;
        return this;
    }

    @ApiModelProperty(value="The hour (0 - 23) in which the device will reboot, reboot will happen in the timezone of the device")
    @JsonProperty(value="restartHour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRestartHour() {
        return this.restartHour;
    }

    @JsonProperty(value="restartHour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestartHour(Integer restartHour) {
        this.restartHour = restartHour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hardware hardware = (Hardware)o;
        return Objects.equals(this.displayMaximumBackLight, hardware.displayMaximumBackLight) && Objects.equals(this.restartHour, hardware.restartHour);
    }

    public int hashCode() {
        return Objects.hash(this.displayMaximumBackLight, this.restartHour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hardware {\n");
        sb.append("    displayMaximumBackLight: ").append(this.toIndentedString(this.displayMaximumBackLight)).append("\n");
        sb.append("    restartHour: ").append(this.toIndentedString(this.restartHour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Hardware fromJson(String jsonString) throws JsonProcessingException {
        return (Hardware)JSON.getMapper().readValue(jsonString, Hardware.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

