/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SourceOfFunds;
import com.adyen.model.legalentitymanagement.WebData;
import com.adyen.model.legalentitymanagement.WebDataExemption;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"capability", "industryCode", "legalEntityId", "salesChannels", "service", "sourceOfFunds", "webData", "webDataExemption"})
public class BusinessLineInfoUpdate {
    public static final String JSON_PROPERTY_CAPABILITY = "capability";
    private CapabilityEnum capability;
    public static final String JSON_PROPERTY_INDUSTRY_CODE = "industryCode";
    private String industryCode;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_SALES_CHANNELS = "salesChannels";
    private List<String> salesChannels = null;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private ServiceEnum service;
    public static final String JSON_PROPERTY_SOURCE_OF_FUNDS = "sourceOfFunds";
    private SourceOfFunds sourceOfFunds;
    public static final String JSON_PROPERTY_WEB_DATA = "webData";
    private List<WebData> webData = null;
    public static final String JSON_PROPERTY_WEB_DATA_EXEMPTION = "webDataExemption";
    private WebDataExemption webDataExemption;

    public BusinessLineInfoUpdate capability(CapabilityEnum capability) {
        this.capability = capability;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The capability for which you are creating the business line. For example, **receivePayments**.")
    @JsonProperty(value="capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilityEnum getCapability() {
        return this.capability;
    }

    @Deprecated
    @JsonProperty(value="capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapability(CapabilityEnum capability) {
        this.capability = capability;
    }

    public BusinessLineInfoUpdate industryCode(String industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    @ApiModelProperty(value="A code that represents the industry of your legal entity. For example, **4431A** for computer software stores.")
    @JsonProperty(value="industryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndustryCode() {
        return this.industryCode;
    }

    @JsonProperty(value="industryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    public BusinessLineInfoUpdate legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) that owns the business line.")
    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public BusinessLineInfoUpdate salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        return this;
    }

    public BusinessLineInfoUpdate addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the `service` **paymentProcessing**.")
    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
    }

    public BusinessLineInfoUpdate service(ServiceEnum service) {
        this.service = service;
        return this;
    }

    @ApiModelProperty(required=true, value="The service for which you are creating the business line.  Possible values: **paymentProcessing**, **issuing**, **banking**")
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceEnum getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(ServiceEnum service) {
        this.service = service;
    }

    public BusinessLineInfoUpdate sourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceOfFunds getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
    }

    public BusinessLineInfoUpdate webData(List<WebData> webData) {
        this.webData = webData;
        return this;
    }

    public BusinessLineInfoUpdate addWebDataItem(WebData webDataItem) {
        if (this.webData == null) {
            this.webData = new ArrayList<WebData>();
        }
        this.webData.add(webDataItem);
        return this;
    }

    @ApiModelProperty(value="List of website URLs where your user's goods or services are sold. When this is required for a service but your user does not have an online presence, provide the reason in the `webDataExemption` object.")
    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WebData> getWebData() {
        return this.webData;
    }

    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebData(List<WebData> webData) {
        this.webData = webData;
    }

    public BusinessLineInfoUpdate webDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="webDataExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebDataExemption getWebDataExemption() {
        return this.webDataExemption;
    }

    @JsonProperty(value="webDataExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessLineInfoUpdate businessLineInfoUpdate = (BusinessLineInfoUpdate)o;
        return Objects.equals((Object)this.capability, (Object)businessLineInfoUpdate.capability) && Objects.equals(this.industryCode, businessLineInfoUpdate.industryCode) && Objects.equals(this.legalEntityId, businessLineInfoUpdate.legalEntityId) && Objects.equals(this.salesChannels, businessLineInfoUpdate.salesChannels) && Objects.equals((Object)this.service, (Object)businessLineInfoUpdate.service) && Objects.equals(this.sourceOfFunds, businessLineInfoUpdate.sourceOfFunds) && Objects.equals(this.webData, businessLineInfoUpdate.webData) && Objects.equals(this.webDataExemption, businessLineInfoUpdate.webDataExemption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capability, this.industryCode, this.legalEntityId, this.salesChannels, this.service, this.sourceOfFunds, this.webData, this.webDataExemption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessLineInfoUpdate {\n");
        sb.append("    capability: ").append(this.toIndentedString((Object)this.capability)).append("\n");
        sb.append("    industryCode: ").append(this.toIndentedString(this.industryCode)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("    service: ").append(this.toIndentedString((Object)this.service)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString(this.sourceOfFunds)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("    webDataExemption: ").append(this.toIndentedString(this.webDataExemption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BusinessLineInfoUpdate fromJson(String jsonString) throws JsonProcessingException {
        return (BusinessLineInfoUpdate)JSON.getMapper().readValue(jsonString, BusinessLineInfoUpdate.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ServiceEnum {
        PAYMENTPROCESSING("paymentProcessing"),
        ISSUING("issuing"),
        BANKING("banking");

        private String value;

        private ServiceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceEnum fromValue(String value) {
            for (ServiceEnum b : ServiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CapabilityEnum {
        RECEIVEPAYMENTS("receivePayments"),
        RECEIVEFROMPLATFORMPAYMENTS("receiveFromPlatformPayments"),
        ISSUEBANKACCOUNT("issueBankAccount");

        private String value;

        private CapabilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CapabilityEnum fromValue(String value) {
            for (CapabilityEnum b : CapabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

