/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DisableRequest {
    public static final String SERIALIZED_NAME_CONTRACT = "contract";
    @SerializedName(value="contract")
    private String contract;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public DisableRequest contract(String contract) {
        this.contract = contract;
        return this;
    }

    @ApiModelProperty(value="Specify the contract if you only want to disable a specific use.  This field can be set to one of the following values, or to their combination (comma-separated): * ONECLICK * RECURRING * PAYOUT")
    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public DisableRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public DisableRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The ID that uniquely identifies the recurring detail reference.  If it is not provided, the whole recurring contract of the `shopperReference` will be disabled, which includes all recurring details.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public DisableRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID that uniquely identifies the shopper.  This `shopperReference` must be the same as the `shopperReference` used in the initial payment.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisableRequest disableRequest = (DisableRequest)o;
        return Objects.equals(this.contract, disableRequest.contract) && Objects.equals(this.merchantAccount, disableRequest.merchantAccount) && Objects.equals(this.recurringDetailReference, disableRequest.recurringDetailReference) && Objects.equals(this.shopperReference, disableRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.contract, this.merchantAccount, this.recurringDetailReference, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisableRequest {\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DisableRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `DisableRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT) != null && !jsonObj.get(SERIALIZED_NAME_CONTRACT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `contract` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
    }

    public static DisableRequest fromJson(String jsonString) throws IOException {
        return (DisableRequest)JSON.getGson().fromJson(jsonString, DisableRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTRACT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        log = Logger.getLogger(DisableRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DisableRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DisableRequest.class));
            return new TypeAdapter<DisableRequest>(){

                public void write(JsonWriter out, DisableRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DisableRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DisableRequest.validateJsonObject(jsonObj);
                    return (DisableRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

