/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.ThreeDSecureData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CancelOrRefundRequest {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MPI_DATA = "mpiData";
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData;
    public static final String SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE = "originalMerchantReference";
    @SerializedName(value="originalMerchantReference")
    private String originalMerchantReference;
    public static final String SERIALIZED_NAME_ORIGINAL_REFERENCE = "originalReference";
    @SerializedName(value="originalReference")
    private String originalReference;
    public static final String SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    @SerializedName(value="platformChargebackLogic")
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_TENDER_REFERENCE = "tenderReference";
    @SerializedName(value="tenderReference")
    private String tenderReference;
    public static final String SERIALIZED_NAME_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
    @SerializedName(value="uniqueTerminalId")
    private String uniqueTerminalId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CancelOrRefundRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CancelOrRefundRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CancelOrRefundRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CancelOrRefundRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public CancelOrRefundRequest originalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The original merchant reference to cancel.")
    public String getOriginalMerchantReference() {
        return this.originalMerchantReference;
    }

    public void setOriginalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
    }

    public CancelOrRefundRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  ")
    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public CancelOrRefundRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public CancelOrRefundRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CancelOrRefundRequest tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return this;
    }

    @ApiModelProperty(value="The transaction reference provided by the PED. For point-of-sale integrations only.")
    public String getTenderReference() {
        return this.tenderReference;
    }

    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public CancelOrRefundRequest uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return this;
    }

    @ApiModelProperty(value="Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.")
    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelOrRefundRequest cancelOrRefundRequest = (CancelOrRefundRequest)o;
        return Objects.equals(this.additionalData, cancelOrRefundRequest.additionalData) && Objects.equals(this.merchantAccount, cancelOrRefundRequest.merchantAccount) && Objects.equals(this.mpiData, cancelOrRefundRequest.mpiData) && Objects.equals(this.originalMerchantReference, cancelOrRefundRequest.originalMerchantReference) && Objects.equals(this.originalReference, cancelOrRefundRequest.originalReference) && Objects.equals(this.platformChargebackLogic, cancelOrRefundRequest.platformChargebackLogic) && Objects.equals(this.reference, cancelOrRefundRequest.reference) && Objects.equals(this.tenderReference, cancelOrRefundRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, cancelOrRefundRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.merchantAccount, this.mpiData, this.originalMerchantReference, this.originalReference, this.platformChargebackLogic, this.reference, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelOrRefundRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    originalMerchantReference: ").append(this.toIndentedString(this.originalMerchantReference)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    tenderReference: ").append(this.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(this.toIndentedString(this.uniqueTerminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CancelOrRefundRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CancelOrRefundRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA) != null) {
            ThreeDSecureData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `originalMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `originalReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC) != null) {
            PlatformChargebackLogic.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `tenderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `uniqueTerminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID).toString()));
        }
    }

    public static CancelOrRefundRequest fromJson(String jsonString) throws IOException {
        return (CancelOrRefundRequest)JSON.getGson().fromJson(jsonString, CancelOrRefundRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MPI_DATA);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_TENDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_UNIQUE_TERMINAL_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ORIGINAL_REFERENCE);
        log = Logger.getLogger(CancelOrRefundRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CancelOrRefundRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CancelOrRefundRequest.class));
            return new TypeAdapter<CancelOrRefundRequest>(){

                public void write(JsonWriter out, CancelOrRefundRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CancelOrRefundRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CancelOrRefundRequest.validateJsonObject(jsonObj);
                    return (CancelOrRefundRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

