/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreeDSRequestData {
    public static final String SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE = "challengeWindowSize";
    @SerializedName(value="challengeWindowSize")
    private ChallengeWindowSizeEnum challengeWindowSize;
    public static final String SERIALIZED_NAME_DATA_ONLY = "dataOnly";
    @SerializedName(value="dataOnly")
    private DataOnlyEnum dataOnly;
    public static final String SERIALIZED_NAME_NATIVE_THREE_D_S = "nativeThreeDS";
    @SerializedName(value="nativeThreeDS")
    private NativeThreeDSEnum nativeThreeDS;
    public static final String SERIALIZED_NAME_THREE_D_S_VERSION = "threeDSVersion";
    @SerializedName(value="threeDSVersion")
    private ThreeDSVersionEnum threeDSVersion;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ThreeDSRequestData challengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
        return this;
    }

    @ApiModelProperty(value="Dimensions of the 3DS2 challenge window to be displayed to the cardholder.  Possible values:  * **01** - size of 250x400  * **02** - size of 390x400 * **03** - size of 500x600 * **04** - size of 600x400 * **05** - Fullscreen")
    public ChallengeWindowSizeEnum getChallengeWindowSize() {
        return this.challengeWindowSize;
    }

    public void setChallengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
    }

    public ThreeDSRequestData dataOnly(DataOnlyEnum dataOnly) {
        this.dataOnly = dataOnly;
        return this;
    }

    @ApiModelProperty(value="Flag for data only flow.")
    public DataOnlyEnum getDataOnly() {
        return this.dataOnly;
    }

    public void setDataOnly(DataOnlyEnum dataOnly) {
        this.dataOnly = dataOnly;
    }

    public ThreeDSRequestData nativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
        this.nativeThreeDS = nativeThreeDS;
        return this;
    }

    @ApiModelProperty(value="Indicates if [native 3D Secure authentication](https://docs.adyen.com/online-payments/3d-secure/native-3ds2) should be used when available.  Possible values: * **preferred**: Use native 3D Secure authentication when available.")
    public NativeThreeDSEnum getNativeThreeDS() {
        return this.nativeThreeDS;
    }

    public void setNativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
        this.nativeThreeDS = nativeThreeDS;
    }

    public ThreeDSRequestData threeDSVersion(ThreeDSVersionEnum threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @ApiModelProperty(value="The version of 3D Secure to use.  Possible values:  * **2.1.0** * **2.2.0**")
    public ThreeDSVersionEnum getThreeDSVersion() {
        return this.threeDSVersion;
    }

    public void setThreeDSVersion(ThreeDSVersionEnum threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSRequestData threeDSRequestData = (ThreeDSRequestData)o;
        return Objects.equals((Object)this.challengeWindowSize, (Object)threeDSRequestData.challengeWindowSize) && Objects.equals((Object)this.dataOnly, (Object)threeDSRequestData.dataOnly) && Objects.equals((Object)this.nativeThreeDS, (Object)threeDSRequestData.nativeThreeDS) && Objects.equals((Object)this.threeDSVersion, (Object)threeDSRequestData.threeDSVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.challengeWindowSize, this.dataOnly, this.nativeThreeDS, this.threeDSVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSRequestData {\n");
        sb.append("    challengeWindowSize: ").append(this.toIndentedString((Object)this.challengeWindowSize)).append("\n");
        sb.append("    dataOnly: ").append(this.toIndentedString((Object)this.dataOnly)).append("\n");
        sb.append("    nativeThreeDS: ").append(this.toIndentedString((Object)this.nativeThreeDS)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString((Object)this.threeDSVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDSRequestData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDSRequestData` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `challengeWindowSize` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE).toString()));
            }
            ChallengeWindowSizeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_ONLY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATA_ONLY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `dataOnly` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA_ONLY).toString()));
            }
            DataOnlyEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DATA_ONLY).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_NATIVE_THREE_D_S) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NATIVE_THREE_D_S).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `nativeThreeDS` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NATIVE_THREE_D_S).toString()));
            }
            NativeThreeDSEnum.fromValue(jsonObj.get(SERIALIZED_NAME_NATIVE_THREE_D_S).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `threeDSVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION).toString()));
            }
            ThreeDSVersionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION).getAsString());
        }
    }

    public static ThreeDSRequestData fromJson(String jsonString) throws IOException {
        return (ThreeDSRequestData)JSON.getGson().fromJson(jsonString, ThreeDSRequestData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE);
        openapiFields.add(SERIALIZED_NAME_DATA_ONLY);
        openapiFields.add(SERIALIZED_NAME_NATIVE_THREE_D_S);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_VERSION);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ThreeDSRequestData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ThreeDSRequestData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ThreeDSRequestData.class));
            return new TypeAdapter<ThreeDSRequestData>(){

                public void write(JsonWriter out, ThreeDSRequestData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ThreeDSRequestData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ThreeDSRequestData.validateJsonObject(jsonObj);
                    return (ThreeDSRequestData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThreeDSVersionEnum {
        _1_0("2.1.0"),
        _2_0("2.2.0");

        private String value;

        private ThreeDSVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThreeDSVersionEnum fromValue(String value) {
            for (ThreeDSVersionEnum b : ThreeDSVersionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ThreeDSVersionEnum> {
            public void write(JsonWriter jsonWriter, ThreeDSVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ThreeDSVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThreeDSVersionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NativeThreeDSEnum {
        PREFERRED("preferred");

        private String value;

        private NativeThreeDSEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NativeThreeDSEnum fromValue(String value) {
            for (NativeThreeDSEnum b : NativeThreeDSEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<NativeThreeDSEnum> {
            public void write(JsonWriter jsonWriter, NativeThreeDSEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NativeThreeDSEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NativeThreeDSEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DataOnlyEnum {
        FALSE("false"),
        TRUE("true");

        private String value;

        private DataOnlyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DataOnlyEnum fromValue(String value) {
            for (DataOnlyEnum b : DataOnlyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DataOnlyEnum> {
            public void write(JsonWriter jsonWriter, DataOnlyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DataOnlyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DataOnlyEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChallengeWindowSizeEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05");

        private String value;

        private ChallengeWindowSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChallengeWindowSizeEnum fromValue(String value) {
            for (ChallengeWindowSizeEnum b : ChallengeWindowSizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChallengeWindowSizeEnum> {
            public void write(JsonWriter jsonWriter, ChallengeWindowSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChallengeWindowSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChallengeWindowSizeEnum.fromValue(value);
            }
        }
    }
}

