/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdditionalDataRetry {
    public static final String SERIALIZED_NAME_RETRY_CHAIN_ATTEMPT_NUMBER = "retry.chainAttemptNumber";
    @SerializedName(value="retry.chainAttemptNumber")
    private String retryChainAttemptNumber;
    public static final String SERIALIZED_NAME_RETRY_ORDER_ATTEMPT_NUMBER = "retry.orderAttemptNumber";
    @SerializedName(value="retry.orderAttemptNumber")
    private String retryOrderAttemptNumber;
    public static final String SERIALIZED_NAME_RETRY_SKIP_RETRY = "retry.skipRetry";
    @SerializedName(value="retry.skipRetry")
    private String retrySkipRetry;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public AdditionalDataRetry retryChainAttemptNumber(String retryChainAttemptNumber) {
        this.retryChainAttemptNumber = retryChainAttemptNumber;
        return this;
    }

    @ApiModelProperty(value="The number of times the transaction (not order) has been retried between different payment service providers. For instance, the `chainAttemptNumber` set to 2 means that this transaction has been recently tried on another provider before being sent to Adyen.  > If you submit `retry.chainAttemptNumber`, `retry.orderAttemptNumber`, and `retry.skipRetry` values, we also recommend you provide the `merchantOrderReference` to facilitate linking payment attempts together.")
    public String getRetryChainAttemptNumber() {
        return this.retryChainAttemptNumber;
    }

    public void setRetryChainAttemptNumber(String retryChainAttemptNumber) {
        this.retryChainAttemptNumber = retryChainAttemptNumber;
    }

    public AdditionalDataRetry retryOrderAttemptNumber(String retryOrderAttemptNumber) {
        this.retryOrderAttemptNumber = retryOrderAttemptNumber;
        return this;
    }

    @ApiModelProperty(value="The index of the attempt to bill a particular order, which is identified by the `merchantOrderReference` field. For example, if a recurring transaction fails and is retried one day later, then the order number for these attempts would be 1 and 2, respectively.  > If you submit `retry.chainAttemptNumber`, `retry.orderAttemptNumber`, and `retry.skipRetry` values, we also recommend you provide the `merchantOrderReference` to facilitate linking payment attempts together.")
    public String getRetryOrderAttemptNumber() {
        return this.retryOrderAttemptNumber;
    }

    public void setRetryOrderAttemptNumber(String retryOrderAttemptNumber) {
        this.retryOrderAttemptNumber = retryOrderAttemptNumber;
    }

    public AdditionalDataRetry retrySkipRetry(String retrySkipRetry) {
        this.retrySkipRetry = retrySkipRetry;
        return this;
    }

    @ApiModelProperty(value="The Boolean value indicating whether Adyen should skip or retry this transaction, if possible.  > If you submit `retry.chainAttemptNumber`, `retry.orderAttemptNumber`, and `retry.skipRetry` values, we also recommend you provide the `merchantOrderReference` to facilitate linking payment attempts together.")
    public String getRetrySkipRetry() {
        return this.retrySkipRetry;
    }

    public void setRetrySkipRetry(String retrySkipRetry) {
        this.retrySkipRetry = retrySkipRetry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalDataRetry additionalDataRetry = (AdditionalDataRetry)o;
        return Objects.equals(this.retryChainAttemptNumber, additionalDataRetry.retryChainAttemptNumber) && Objects.equals(this.retryOrderAttemptNumber, additionalDataRetry.retryOrderAttemptNumber) && Objects.equals(this.retrySkipRetry, additionalDataRetry.retrySkipRetry);
    }

    public int hashCode() {
        return Objects.hash(this.retryChainAttemptNumber, this.retryOrderAttemptNumber, this.retrySkipRetry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalDataRetry {\n");
        sb.append("    retryChainAttemptNumber: ").append(this.toIndentedString(this.retryChainAttemptNumber)).append("\n");
        sb.append("    retryOrderAttemptNumber: ").append(this.toIndentedString(this.retryOrderAttemptNumber)).append("\n");
        sb.append("    retrySkipRetry: ").append(this.toIndentedString(this.retrySkipRetry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AdditionalDataRetry is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AdditionalDataRetry` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETRY_CHAIN_ATTEMPT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_RETRY_CHAIN_ATTEMPT_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `retry.chainAttemptNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RETRY_CHAIN_ATTEMPT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETRY_ORDER_ATTEMPT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_RETRY_ORDER_ATTEMPT_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `retry.orderAttemptNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RETRY_ORDER_ATTEMPT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETRY_SKIP_RETRY) != null && !jsonObj.get(SERIALIZED_NAME_RETRY_SKIP_RETRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `retry.skipRetry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RETRY_SKIP_RETRY).toString()));
        }
    }

    public static AdditionalDataRetry fromJson(String jsonString) throws IOException {
        return (AdditionalDataRetry)JSON.getGson().fromJson(jsonString, AdditionalDataRetry.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RETRY_CHAIN_ATTEMPT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_RETRY_ORDER_ATTEMPT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_RETRY_SKIP_RETRY);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(AdditionalDataRetry.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AdditionalDataRetry.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AdditionalDataRetry.class));
            return new TypeAdapter<AdditionalDataRetry>(){

                public void write(JsonWriter out, AdditionalDataRetry value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AdditionalDataRetry read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AdditionalDataRetry.validateJsonObject(jsonObj);
                    return (AdditionalDataRetry)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

