/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.notification;

import com.adyen.deserializer.MarketPayNotificationMessageDeserializer;
import com.adyen.model.marketpay.notification.GenericWebhook;
import com.adyen.model.notification.NotificationRequest;
import com.adyen.model.terminal.TerminalAPIRequest;
import com.adyen.terminal.serialization.TerminalAPIGsonBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public class WebhookHandler {
    private static final Gson GSON = new Gson();
    private final Gson marketPayGson;
    private final Gson terminalGson;

    public WebhookHandler() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(GenericWebhook.class, (Object)new MarketPayNotificationMessageDeserializer());
        this.marketPayGson = gsonBuilder.create();
        this.terminalGson = TerminalAPIGsonBuilder.create();
    }

    public NotificationRequest handleNotificationJson(String json) throws IOException {
        return NotificationRequest.fromJson(json);
    }

    public GenericWebhook handleMarketpayNotificationJson(String json) {
        return (GenericWebhook)this.marketPayGson.fromJson(json, GenericWebhook.class);
    }

    public TerminalAPIRequest handleTerminalNotificationJson(String json) {
        return (TerminalAPIRequest)this.terminalGson.fromJson(json, new TypeToken<TerminalAPIRequest>(){}.getType());
    }
}

