/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferNotificationTransferTracking {
    public static final String SERIALIZED_NAME_ESTIMATED_ARRIVAL_TIME = "estimatedArrivalTime";
    @SerializedName(value="estimatedArrivalTime")
    private OffsetDateTime estimatedArrivalTime;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TransferNotificationTransferTracking estimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
        return this;
    }

    @ApiModelProperty(value="The estimated time the beneficiary should have access to the funds.")
    public OffsetDateTime getEstimatedArrivalTime() {
        return this.estimatedArrivalTime;
    }

    public void setEstimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
    }

    public TransferNotificationTransferTracking status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The tracking status of the transfer.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferNotificationTransferTracking transferNotificationTransferTracking = (TransferNotificationTransferTracking)o;
        return Objects.equals(this.estimatedArrivalTime, transferNotificationTransferTracking.estimatedArrivalTime) && Objects.equals((Object)this.status, (Object)transferNotificationTransferTracking.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.estimatedArrivalTime, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferNotificationTransferTracking {\n");
        sb.append("    estimatedArrivalTime: ").append(this.toIndentedString(this.estimatedArrivalTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferNotificationTransferTracking is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransferNotificationTransferTracking` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
    }

    public static TransferNotificationTransferTracking fromJson(String jsonString) throws IOException {
        return (TransferNotificationTransferTracking)JSON.getGson().fromJson(jsonString, TransferNotificationTransferTracking.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ESTIMATED_ARRIVAL_TIME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TransferNotificationTransferTracking.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferNotificationTransferTracking.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferNotificationTransferTracking.class));
            return new TypeAdapter<TransferNotificationTransferTracking>(){

                public void write(JsonWriter out, TransferNotificationTransferTracking value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferNotificationTransferTracking read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransferNotificationTransferTracking.validateJsonObject(jsonObj);
                    return (TransferNotificationTransferTracking)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        CREDITED("credited");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

