/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataCenter {
    public static final String SERIALIZED_NAME_LIVE_PREFIX = "livePrefix";
    @SerializedName(value="livePrefix")
    private String livePrefix;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public DataCenter livePrefix(String livePrefix) {
        this.livePrefix = livePrefix;
        return this;
    }

    @ApiModelProperty(value="The unique [live URL prefix](https://docs.adyen.com/development-resources/live-endpoints#live-url-prefix) for your live endpoint. Each data center has its own live URL prefix.  This field is empty for requests made in the test environment.")
    public String getLivePrefix() {
        return this.livePrefix;
    }

    public void setLivePrefix(String livePrefix) {
        this.livePrefix = livePrefix;
    }

    public DataCenter name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name assigned to a data center, for example **EU** for the European data center. Possible values are:  * **default**: the European data center. This value is always returned in the test environment.  * **AU** * **EU** * **US**")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCenter dataCenter = (DataCenter)o;
        return Objects.equals(this.livePrefix, dataCenter.livePrefix) && Objects.equals(this.name, dataCenter.name);
    }

    public int hashCode() {
        return Objects.hash(this.livePrefix, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataCenter {\n");
        sb.append("    livePrefix: ").append(this.toIndentedString(this.livePrefix)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DataCenter is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `DataCenter` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIVE_PREFIX) != null && !jsonObj.get(SERIALIZED_NAME_LIVE_PREFIX).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `livePrefix` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIVE_PREFIX).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static DataCenter fromJson(String jsonString) throws IOException {
        return (DataCenter)JSON.getGson().fromJson(jsonString, DataCenter.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LIVE_PREFIX);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(DataCenter.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DataCenter.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DataCenter.class));
            return new TypeAdapter<DataCenter>(){

                public void write(JsonWriter out, DataCenter value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DataCenter read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DataCenter.validateJsonObject(jsonObj);
                    return (DataCenter)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

