/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PciSigningRequest {
    public static final String SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES = "pciTemplateReferences";
    @SerializedName(value="pciTemplateReferences")
    private List<String> pciTemplateReferences = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SIGNED_BY = "signedBy";
    @SerializedName(value="signedBy")
    private String signedBy;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PciSigningRequest pciTemplateReferences(List<String> pciTemplateReferences) {
        this.pciTemplateReferences = pciTemplateReferences;
        return this;
    }

    public PciSigningRequest addPciTemplateReferencesItem(String pciTemplateReferencesItem) {
        this.pciTemplateReferences.add(pciTemplateReferencesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The array of Adyen-generated unique identifiers for the questionnaires.")
    public List<String> getPciTemplateReferences() {
        return this.pciTemplateReferences;
    }

    public void setPciTemplateReferences(List<String> pciTemplateReferences) {
        this.pciTemplateReferences = pciTemplateReferences;
    }

    public PciSigningRequest signedBy(String signedBy) {
        this.signedBy = signedBy;
        return this;
    }

    @ApiModelProperty(required=true, value="The [legal entity ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) of the individual who signs the PCI questionnaire.")
    public String getSignedBy() {
        return this.signedBy;
    }

    public void setSignedBy(String signedBy) {
        this.signedBy = signedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PciSigningRequest pciSigningRequest = (PciSigningRequest)o;
        return Objects.equals(this.pciTemplateReferences, pciSigningRequest.pciTemplateReferences) && Objects.equals(this.signedBy, pciSigningRequest.signedBy);
    }

    public int hashCode() {
        return Objects.hash(this.pciTemplateReferences, this.signedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PciSigningRequest {\n");
        sb.append("    pciTemplateReferences: ").append(this.toIndentedString(this.pciTemplateReferences)).append("\n");
        sb.append("    signedBy: ").append(this.toIndentedString(this.signedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PciSigningRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PciSigningRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES) != null && !jsonObj.get(SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `pciTemplateReferences` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIGNED_BY) != null && !jsonObj.get(SERIALIZED_NAME_SIGNED_BY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `signedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNED_BY).toString()));
        }
    }

    public static PciSigningRequest fromJson(String jsonString) throws IOException {
        return (PciSigningRequest)JSON.getGson().fromJson(jsonString, PciSigningRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES);
        openapiFields.add(SERIALIZED_NAME_SIGNED_BY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGNED_BY);
        log = Logger.getLogger(PciSigningRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PciSigningRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PciSigningRequest.class));
            return new TypeAdapter<PciSigningRequest>(){

                public void write(JsonWriter out, PciSigningRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PciSigningRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PciSigningRequest.validateJsonObject(jsonObj);
                    return (PciSigningRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

