/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OnboardingTheme {
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    private Map<String, String> properties = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public OnboardingTheme createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The creation date of the theme.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OnboardingTheme description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the theme.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OnboardingTheme id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the theme.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OnboardingTheme properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public OnboardingTheme putPropertiesItem(String key, String propertiesItem) {
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The properties of the theme.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public OnboardingTheme updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="The date when the theme was last updated.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnboardingTheme onboardingTheme = (OnboardingTheme)o;
        return Objects.equals(this.createdAt, onboardingTheme.createdAt) && Objects.equals(this.description, onboardingTheme.description) && Objects.equals(this.id, onboardingTheme.id) && Objects.equals(this.properties, onboardingTheme.properties) && Objects.equals(this.updatedAt, onboardingTheme.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.description, this.id, this.properties, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OnboardingTheme {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OnboardingTheme is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `OnboardingTheme` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
    }

    public static OnboardingTheme fromJson(String jsonString) throws IOException {
        return (OnboardingTheme)JSON.getGson().fromJson(jsonString, OnboardingTheme.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PROPERTIES);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PROPERTIES);
        log = Logger.getLogger(OnboardingTheme.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OnboardingTheme.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OnboardingTheme.class));
            return new TypeAdapter<OnboardingTheme>(){

                public void write(JsonWriter out, OnboardingTheme value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OnboardingTheme read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OnboardingTheme.validateJsonObject(jsonObj);
                    return (OnboardingTheme)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

