/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.AccountHolderNotificationData;
import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccountHolderNotificationRequest {
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private AccountHolderNotificationData data;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private String environment;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public AccountHolderNotificationRequest data(AccountHolderNotificationData data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountHolderNotificationData getData() {
        return this.data;
    }

    public void setData(AccountHolderNotificationData data) {
        this.data = data;
    }

    public AccountHolderNotificationRequest environment(String environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="The environment from which the webhook originated.  Possible values: **test**, **live**.")
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public AccountHolderNotificationRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of notification.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderNotificationRequest accountHolderNotificationRequest = (AccountHolderNotificationRequest)o;
        return Objects.equals(this.data, accountHolderNotificationRequest.data) && Objects.equals(this.environment, accountHolderNotificationRequest.environment) && Objects.equals((Object)this.type, (Object)accountHolderNotificationRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.environment, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderNotificationRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountHolderNotificationRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AccountHolderNotificationRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DATA) != null) {
            AccountHolderNotificationData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `environment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static AccountHolderNotificationRequest fromJson(String jsonString) throws IOException {
        return (AccountHolderNotificationRequest)JSON.getGson().fromJson(jsonString, AccountHolderNotificationRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        log = Logger.getLogger(AccountHolderNotificationRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountHolderNotificationRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountHolderNotificationRequest.class));
            return new TypeAdapter<AccountHolderNotificationRequest>(){

                public void write(JsonWriter out, AccountHolderNotificationRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountHolderNotificationRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccountHolderNotificationRequest.validateJsonObject(jsonObj);
                    return (AccountHolderNotificationRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        UPDATED("balancePlatform.accountHolder.updated"),
        CREATED("balancePlatform.accountHolder.created");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

