/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PaymentVerificationRequest {
    public static final String SERIALIZED_NAME_PAYLOAD = "payload";
    @SerializedName(value="payload")
    private String payload;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PaymentVerificationRequest payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(required=true, value="Encrypted and signed payment result data. You should receive this value from the Checkout SDK after the shopper completes the payment.")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentVerificationRequest paymentVerificationRequest = (PaymentVerificationRequest)o;
        return Objects.equals(this.payload, paymentVerificationRequest.payload);
    }

    public int hashCode() {
        return Objects.hash(this.payload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentVerificationRequest {\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentVerificationRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaymentVerificationRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYLOAD) != null && !jsonObj.get(SERIALIZED_NAME_PAYLOAD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `payload` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYLOAD).toString()));
        }
    }

    public static PaymentVerificationRequest fromJson(String jsonString) throws IOException {
        return (PaymentVerificationRequest)JSON.getGson().fromJson(jsonString, PaymentVerificationRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PAYLOAD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PAYLOAD);
        log = Logger.getLogger(PaymentVerificationRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentVerificationRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentVerificationRequest.class));
            return new TypeAdapter<PaymentVerificationRequest>(){

                public void write(JsonWriter out, PaymentVerificationRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentVerificationRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentVerificationRequest.validateJsonObject(jsonObj);
                    return (PaymentVerificationRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

